/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Impact
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Impact> {
    private static final SdkField<Double> MAX_IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxImpact").getter(Impact.getter(Impact::maxImpact)).setter(Impact.setter(Builder::maxImpact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxImpact").build()}).build();
    private static final SdkField<Double> TOTAL_IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalImpact").getter(Impact.getter(Impact::totalImpact)).setter(Impact.setter(Builder::totalImpact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalImpact").build()}).build();
    private static final SdkField<Double> TOTAL_ACTUAL_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalActualSpend").getter(Impact.getter(Impact::totalActualSpend)).setter(Impact.setter(Builder::totalActualSpend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalActualSpend").build()}).build();
    private static final SdkField<Double> TOTAL_EXPECTED_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalExpectedSpend").getter(Impact.getter(Impact::totalExpectedSpend)).setter(Impact.setter(Builder::totalExpectedSpend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalExpectedSpend").build()}).build();
    private static final SdkField<Double> TOTAL_IMPACT_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalImpactPercentage").getter(Impact.getter(Impact::totalImpactPercentage)).setter(Impact.setter(Builder::totalImpactPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalImpactPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_IMPACT_FIELD, TOTAL_IMPACT_FIELD, TOTAL_ACTUAL_SPEND_FIELD, TOTAL_EXPECTED_SPEND_FIELD, TOTAL_IMPACT_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Impact.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double maxImpact;
    private final Double totalImpact;
    private final Double totalActualSpend;
    private final Double totalExpectedSpend;
    private final Double totalImpactPercentage;

    private Impact(BuilderImpl builder) {
        this.maxImpact = builder.maxImpact;
        this.totalImpact = builder.totalImpact;
        this.totalActualSpend = builder.totalActualSpend;
        this.totalExpectedSpend = builder.totalExpectedSpend;
        this.totalImpactPercentage = builder.totalImpactPercentage;
    }

    public final Double maxImpact() {
        return this.maxImpact;
    }

    public final Double totalImpact() {
        return this.totalImpact;
    }

    public final Double totalActualSpend() {
        return this.totalActualSpend;
    }

    public final Double totalExpectedSpend() {
        return this.totalExpectedSpend;
    }

    public final Double totalImpactPercentage() {
        return this.totalImpactPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxImpact());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalImpact());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalActualSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalExpectedSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalImpactPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Impact)) {
            return false;
        }
        Impact other = (Impact)obj;
        return Objects.equals(this.maxImpact(), other.maxImpact()) && Objects.equals(this.totalImpact(), other.totalImpact()) && Objects.equals(this.totalActualSpend(), other.totalActualSpend()) && Objects.equals(this.totalExpectedSpend(), other.totalExpectedSpend()) && Objects.equals(this.totalImpactPercentage(), other.totalImpactPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"Impact").add("MaxImpact", (Object)this.maxImpact()).add("TotalImpact", (Object)this.totalImpact()).add("TotalActualSpend", (Object)this.totalActualSpend()).add("TotalExpectedSpend", (Object)this.totalExpectedSpend()).add("TotalImpactPercentage", (Object)this.totalImpactPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxImpact": {
                return Optional.ofNullable(clazz.cast(this.maxImpact()));
            }
            case "TotalImpact": {
                return Optional.ofNullable(clazz.cast(this.totalImpact()));
            }
            case "TotalActualSpend": {
                return Optional.ofNullable(clazz.cast(this.totalActualSpend()));
            }
            case "TotalExpectedSpend": {
                return Optional.ofNullable(clazz.cast(this.totalExpectedSpend()));
            }
            case "TotalImpactPercentage": {
                return Optional.ofNullable(clazz.cast(this.totalImpactPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Double>> map = new HashMap<String, SdkField<Double>>();
        map.put("MaxImpact", MAX_IMPACT_FIELD);
        map.put("TotalImpact", TOTAL_IMPACT_FIELD);
        map.put("TotalActualSpend", TOTAL_ACTUAL_SPEND_FIELD);
        map.put("TotalExpectedSpend", TOTAL_EXPECTED_SPEND_FIELD);
        map.put("TotalImpactPercentage", TOTAL_IMPACT_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Impact, T> g) {
        return obj -> g.apply((Impact)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double maxImpact;
        private Double totalImpact;
        private Double totalActualSpend;
        private Double totalExpectedSpend;
        private Double totalImpactPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(Impact model) {
            this.maxImpact(model.maxImpact);
            this.totalImpact(model.totalImpact);
            this.totalActualSpend(model.totalActualSpend);
            this.totalExpectedSpend(model.totalExpectedSpend);
            this.totalImpactPercentage(model.totalImpactPercentage);
        }

        public final Double getMaxImpact() {
            return this.maxImpact;
        }

        public final void setMaxImpact(Double maxImpact) {
            this.maxImpact = maxImpact;
        }

        @Override
        public final Builder maxImpact(Double maxImpact) {
            this.maxImpact = maxImpact;
            return this;
        }

        public final Double getTotalImpact() {
            return this.totalImpact;
        }

        public final void setTotalImpact(Double totalImpact) {
            this.totalImpact = totalImpact;
        }

        @Override
        public final Builder totalImpact(Double totalImpact) {
            this.totalImpact = totalImpact;
            return this;
        }

        public final Double getTotalActualSpend() {
            return this.totalActualSpend;
        }

        public final void setTotalActualSpend(Double totalActualSpend) {
            this.totalActualSpend = totalActualSpend;
        }

        @Override
        public final Builder totalActualSpend(Double totalActualSpend) {
            this.totalActualSpend = totalActualSpend;
            return this;
        }

        public final Double getTotalExpectedSpend() {
            return this.totalExpectedSpend;
        }

        public final void setTotalExpectedSpend(Double totalExpectedSpend) {
            this.totalExpectedSpend = totalExpectedSpend;
        }

        @Override
        public final Builder totalExpectedSpend(Double totalExpectedSpend) {
            this.totalExpectedSpend = totalExpectedSpend;
            return this;
        }

        public final Double getTotalImpactPercentage() {
            return this.totalImpactPercentage;
        }

        public final void setTotalImpactPercentage(Double totalImpactPercentage) {
            this.totalImpactPercentage = totalImpactPercentage;
        }

        @Override
        public final Builder totalImpactPercentage(Double totalImpactPercentage) {
            this.totalImpactPercentage = totalImpactPercentage;
            return this;
        }

        public Impact build() {
            return new Impact(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Impact> {
        public Builder maxImpact(Double var1);

        public Builder totalImpact(Double var1);

        public Builder totalActualSpend(Double var1);

        public Builder totalExpectedSpend(Double var1);

        public Builder totalImpactPercentage(Double var1);
    }
}

