/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceType {
    EC2_INSTANCE("Ec2Instance"),
    LAMBDA_FUNCTION("LambdaFunction"),
    EBS_VOLUME("EbsVolume"),
    ECS_SERVICE("EcsService"),
    EC2_AUTO_SCALING_GROUP("Ec2AutoScalingGroup"),
    EC2_INSTANCE_SAVINGS_PLANS("Ec2InstanceSavingsPlans"),
    COMPUTE_SAVINGS_PLANS("ComputeSavingsPlans"),
    SAGE_MAKER_SAVINGS_PLANS("SageMakerSavingsPlans"),
    EC2_RESERVED_INSTANCES("Ec2ReservedInstances"),
    RDS_RESERVED_INSTANCES("RdsReservedInstances"),
    OPEN_SEARCH_RESERVED_INSTANCES("OpenSearchReservedInstances"),
    REDSHIFT_RESERVED_INSTANCES("RedshiftReservedInstances"),
    ELASTI_CACHE_RESERVED_INSTANCES("ElastiCacheReservedInstances"),
    RDS_DB_INSTANCE_STORAGE("RdsDbInstanceStorage"),
    RDS_DB_INSTANCE("RdsDbInstance"),
    AURORA_DB_CLUSTER_STORAGE("AuroraDbClusterStorage"),
    DYNAMO_DB_RESERVED_CAPACITY("DynamoDbReservedCapacity"),
    MEMORY_DB_RESERVED_INSTANCES("MemoryDbReservedInstances"),
    NAT_GATEWAY("NatGateway"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceType> VALUE_MAP;
    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        EnumSet<ResourceType> knownValues = EnumSet.allOf(ResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceType.class, ResourceType::toString);
    }
}

