/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.credentials;

import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.TlsContext;

public class StsWebIdentityCredentialsProvider
extends CredentialsProvider {
    public static StsWebIdentityCredentialsProvider create() {
        return StsWebIdentityCredentialsProvider.builder().build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static long toNativeHandle(CrtResource crtResource) {
        return crtResource == null ? 0L : crtResource.getNativeHandle();
    }

    private StsWebIdentityCredentialsProvider(BuilderImpl builder) {
        try (ClientBootstrap bootstrap = builder.clientBootstrap == null ? new ClientBootstrap(null, null) : builder.clientBootstrap;){
            long nativeHandle = StsWebIdentityCredentialsProvider.stsWebIdentityCredentialsProviderNew(this, StsWebIdentityCredentialsProvider.toNativeHandle(bootstrap), StsWebIdentityCredentialsProvider.toNativeHandle(builder.tlsContext));
            this.acquireNativeHandle(nativeHandle);
            this.addReferenceTo(bootstrap);
            this.addReferenceTo(builder.tlsContext);
        }
        catch (Exception e) {
            throw e;
        }
    }

    private static native long stsWebIdentityCredentialsProviderNew(StsWebIdentityCredentialsProvider var0, long var1, long var3);

    static final class BuilderImpl
    implements Builder {
        private ClientBootstrap clientBootstrap;
        private TlsContext tlsContext;

        BuilderImpl() {
        }

        @Override
        public Builder withClientBootstrap(ClientBootstrap clientBootstrap) {
            this.clientBootstrap = clientBootstrap;
            return this;
        }

        @Override
        public Builder withTlsContext(TlsContext tlsContext) {
            this.tlsContext = tlsContext;
            return this;
        }

        @Override
        public StsWebIdentityCredentialsProvider build() {
            if (this.tlsContext == null) {
                throw new IllegalArgumentException("TlsContext must be provided");
            }
            return new StsWebIdentityCredentialsProvider(this);
        }
    }

    public static interface Builder {
        public Builder withClientBootstrap(ClientBootstrap var1);

        public Builder withTlsContext(TlsContext var1);

        public StsWebIdentityCredentialsProvider build();
    }
}

