/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.net.URI;
import software.amazon.awssdk.crt.http.HttpMonitoringOptions;
import software.amazon.awssdk.crt.http.HttpProxyEnvironmentVariableSetting;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.http.HttpVersion;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsConnectionOptions;
import software.amazon.awssdk.crt.io.TlsContext;

public class HttpClientConnectionManagerOptions {
    public static final int DEFAULT_MAX_BUFFER_SIZE = 16384;
    public static final long DEFAULT_MAX_WINDOW_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_CONNECTIONS = 2;
    private ClientBootstrap clientBootstrap;
    private SocketOptions socketOptions;
    private TlsContext tlsContext;
    private TlsConnectionOptions tlsConnectionOptions;
    private long windowSize = Integer.MAX_VALUE;
    private int bufferSize = 16384;
    private URI uri;
    private int port = -1;
    private int maxConnections = 2;
    private HttpProxyOptions proxyOptions;
    private HttpProxyEnvironmentVariableSetting httpProxyEnvironmentVariableSetting;
    private boolean manualWindowManagement = false;
    private HttpMonitoringOptions monitoringOptions;
    private long maxConnectionIdleInMilliseconds = 0L;
    private HttpVersion expectedHttpVersion = HttpVersion.HTTP_1_1;
    private long connectionAcquisitionTimeoutInMilliseconds;
    private long maxPendingConnectionAcquisitions;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    public HttpClientConnectionManagerOptions withClientBootstrap(ClientBootstrap clientBootstrap) {
        this.clientBootstrap = clientBootstrap;
        return this;
    }

    public ClientBootstrap getClientBootstrap() {
        return this.clientBootstrap;
    }

    public HttpClientConnectionManagerOptions withSocketOptions(SocketOptions socketOptions) {
        this.socketOptions = socketOptions;
        return this;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public HttpClientConnectionManagerOptions withTlsContext(TlsContext tlsContext) {
        this.tlsContext = tlsContext;
        return this;
    }

    public TlsContext getTlsContext() {
        return this.tlsContext;
    }

    public HttpClientConnectionManagerOptions withTlsConnectionOptions(TlsConnectionOptions tlsConnectionOptions) {
        this.tlsConnectionOptions = tlsConnectionOptions;
        return this;
    }

    public TlsConnectionOptions getTlsConnectionOptions() {
        return this.tlsConnectionOptions;
    }

    public HttpClientConnectionManagerOptions withWindowSize(long windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public long getWindowSize() {
        return this.windowSize;
    }

    public HttpClientConnectionManagerOptions withBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public HttpClientConnectionManagerOptions withUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpClientConnectionManagerOptions withPort(int port) {
        this.port = port;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public HttpClientConnectionManagerOptions withMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public HttpClientConnectionManagerOptions withProxyOptions(HttpProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public HttpProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public HttpClientConnectionManagerOptions withProxyEnvironmentVariableSetting(HttpProxyEnvironmentVariableSetting httpProxyEnvironmentVariableSetting) {
        this.httpProxyEnvironmentVariableSetting = httpProxyEnvironmentVariableSetting;
        return this;
    }

    public HttpProxyEnvironmentVariableSetting getHttpProxyEnvironmentVariableSetting() {
        return this.httpProxyEnvironmentVariableSetting;
    }

    public boolean isManualWindowManagement() {
        return this.manualWindowManagement;
    }

    public HttpClientConnectionManagerOptions withManualWindowManagement(boolean manualWindowManagement) {
        this.manualWindowManagement = manualWindowManagement;
        return this;
    }

    public HttpClientConnectionManagerOptions withExpectedHttpVersion(HttpVersion expectedHttpVersion) {
        this.expectedHttpVersion = expectedHttpVersion;
        return this;
    }

    public HttpVersion getExpectedHttpVersion() {
        return this.expectedHttpVersion;
    }

    public HttpClientConnectionManagerOptions withMaxConnectionIdleInMilliseconds(long maxConnectionIdleInMilliseconds) {
        this.maxConnectionIdleInMilliseconds = maxConnectionIdleInMilliseconds;
        return this;
    }

    public long getConnectionAcquisitionTimeoutInMilliseconds() {
        return this.connectionAcquisitionTimeoutInMilliseconds;
    }

    public HttpClientConnectionManagerOptions withConnectionAcquisitionTimeoutInMilliseconds(int connectionAcquisitionTimeoutInMilliseconds) {
        this.connectionAcquisitionTimeoutInMilliseconds = connectionAcquisitionTimeoutInMilliseconds;
        return this;
    }

    public long getMaxPendingConnectionAcquisitions() {
        return this.maxPendingConnectionAcquisitions;
    }

    public HttpClientConnectionManagerOptions withMaxPendingConnectionAcquisitions(int maxPendingConnectionAcquisitions) {
        this.maxPendingConnectionAcquisitions = maxPendingConnectionAcquisitions;
        return this;
    }

    public long getMaxConnectionIdleInMilliseconds() {
        return this.maxConnectionIdleInMilliseconds;
    }

    public HttpClientConnectionManagerOptions withMonitoringOptions(HttpMonitoringOptions monitoringOptions) {
        this.monitoringOptions = monitoringOptions;
        return this;
    }

    public HttpMonitoringOptions getMonitoringOptions() {
        return this.monitoringOptions;
    }

    public void validateOptions() {
        boolean tlsSet;
        URI uri = this.getUri();
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null");
        }
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("URI does not have a Scheme");
        }
        if (!HTTP.equals(uri.getScheme()) && !HTTPS.equals(uri.getScheme())) {
            throw new IllegalArgumentException("URI has unknown Scheme");
        }
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("URI does not have a Host name");
        }
        if (this.clientBootstrap == null) {
            throw new IllegalArgumentException("ClientBootstrap must not be null");
        }
        if (this.socketOptions == null) {
            throw new IllegalArgumentException("SocketOptions must not be null");
        }
        if (this.tlsContext != null && this.tlsConnectionOptions != null) {
            throw new IllegalArgumentException("Cannot set both TlsContext and TlsConnectionOptions.");
        }
        boolean useTls = HTTPS.equals(uri.getScheme());
        boolean bl = tlsSet = this.tlsContext != null || this.tlsConnectionOptions != null;
        if (useTls && !tlsSet) {
            throw new IllegalArgumentException("TlsContext or TlsConnectionOptions must not be null if https is used");
        }
        if (this.windowSize <= 0L) {
            throw new IllegalArgumentException("Window Size must be greater than zero.");
        }
        if (this.maxConnections <= 0) {
            throw new IllegalArgumentException("Max Connections must be greater than zero.");
        }
    }
}

