/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.EventTriggerDimension;
import software.amazon.awssdk.services.customerprofiles.model.EventTriggerDimensionsCopier;
import software.amazon.awssdk.services.customerprofiles.model.EventTriggerLogicalOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventTriggerCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventTriggerCondition> {
    private static final SdkField<List<EventTriggerDimension>> EVENT_TRIGGER_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventTriggerDimensions").getter(EventTriggerCondition.getter(EventTriggerCondition::eventTriggerDimensions)).setter(EventTriggerCondition.setter(Builder::eventTriggerDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggerDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventTriggerDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOGICAL_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalOperator").getter(EventTriggerCondition.getter(EventTriggerCondition::logicalOperatorAsString)).setter(EventTriggerCondition.setter(Builder::logicalOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalOperator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TRIGGER_DIMENSIONS_FIELD, LOGICAL_OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventTriggerCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<EventTriggerDimension> eventTriggerDimensions;
    private final String logicalOperator;

    private EventTriggerCondition(BuilderImpl builder) {
        this.eventTriggerDimensions = builder.eventTriggerDimensions;
        this.logicalOperator = builder.logicalOperator;
    }

    public final boolean hasEventTriggerDimensions() {
        return this.eventTriggerDimensions != null && !(this.eventTriggerDimensions instanceof SdkAutoConstructList);
    }

    public final List<EventTriggerDimension> eventTriggerDimensions() {
        return this.eventTriggerDimensions;
    }

    public final EventTriggerLogicalOperator logicalOperator() {
        return EventTriggerLogicalOperator.fromValue(this.logicalOperator);
    }

    public final String logicalOperatorAsString() {
        return this.logicalOperator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTriggerDimensions() ? this.eventTriggerDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalOperatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTriggerCondition)) {
            return false;
        }
        EventTriggerCondition other = (EventTriggerCondition)obj;
        return this.hasEventTriggerDimensions() == other.hasEventTriggerDimensions() && Objects.equals(this.eventTriggerDimensions(), other.eventTriggerDimensions()) && Objects.equals(this.logicalOperatorAsString(), other.logicalOperatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EventTriggerCondition").add("EventTriggerDimensions", this.hasEventTriggerDimensions() ? this.eventTriggerDimensions() : null).add("LogicalOperator", (Object)this.logicalOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventTriggerDimensions": {
                return Optional.ofNullable(clazz.cast(this.eventTriggerDimensions()));
            }
            case "LogicalOperator": {
                return Optional.ofNullable(clazz.cast(this.logicalOperatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventTriggerDimensions", EVENT_TRIGGER_DIMENSIONS_FIELD);
        map.put("LogicalOperator", LOGICAL_OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventTriggerCondition, T> g) {
        return obj -> g.apply((EventTriggerCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EventTriggerDimension> eventTriggerDimensions = DefaultSdkAutoConstructList.getInstance();
        private String logicalOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(EventTriggerCondition model) {
            this.eventTriggerDimensions(model.eventTriggerDimensions);
            this.logicalOperator(model.logicalOperator);
        }

        public final List<EventTriggerDimension.Builder> getEventTriggerDimensions() {
            List<EventTriggerDimension.Builder> result = EventTriggerDimensionsCopier.copyToBuilder(this.eventTriggerDimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTriggerDimensions(Collection<EventTriggerDimension.BuilderImpl> eventTriggerDimensions) {
            this.eventTriggerDimensions = EventTriggerDimensionsCopier.copyFromBuilder(eventTriggerDimensions);
        }

        @Override
        public final Builder eventTriggerDimensions(Collection<EventTriggerDimension> eventTriggerDimensions) {
            this.eventTriggerDimensions = EventTriggerDimensionsCopier.copy(eventTriggerDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggerDimensions(EventTriggerDimension ... eventTriggerDimensions) {
            this.eventTriggerDimensions(Arrays.asList(eventTriggerDimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggerDimensions(Consumer<EventTriggerDimension.Builder> ... eventTriggerDimensions) {
            this.eventTriggerDimensions(Stream.of(eventTriggerDimensions).map(c -> (EventTriggerDimension)((EventTriggerDimension.Builder)EventTriggerDimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLogicalOperator() {
            return this.logicalOperator;
        }

        public final void setLogicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
        }

        @Override
        public final Builder logicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
            return this;
        }

        @Override
        public final Builder logicalOperator(EventTriggerLogicalOperator logicalOperator) {
            this.logicalOperator(logicalOperator == null ? null : logicalOperator.toString());
            return this;
        }

        public EventTriggerCondition build() {
            return new EventTriggerCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventTriggerCondition> {
        public Builder eventTriggerDimensions(Collection<EventTriggerDimension> var1);

        public Builder eventTriggerDimensions(EventTriggerDimension ... var1);

        public Builder eventTriggerDimensions(Consumer<EventTriggerDimension.Builder> ... var1);

        public Builder logicalOperator(String var1);

        public Builder logicalOperator(EventTriggerLogicalOperator var1);
    }
}

