/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileIdListCopier;
import software.amazon.awssdk.services.customerprofiles.model.ConditionOverrides;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCalculatedAttributeForProfileRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, BatchGetCalculatedAttributeForProfileRequest> {
    private static final SdkField<String> CALCULATED_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatedAttributeName").getter(BatchGetCalculatedAttributeForProfileRequest.getter(BatchGetCalculatedAttributeForProfileRequest::calculatedAttributeName)).setter(BatchGetCalculatedAttributeForProfileRequest.setter(Builder::calculatedAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CalculatedAttributeName").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(BatchGetCalculatedAttributeForProfileRequest.getter(BatchGetCalculatedAttributeForProfileRequest::domainName)).setter(BatchGetCalculatedAttributeForProfileRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<List<String>> PROFILE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileIds").getter(BatchGetCalculatedAttributeForProfileRequest.getter(BatchGetCalculatedAttributeForProfileRequest::profileIds)).setter(BatchGetCalculatedAttributeForProfileRequest.setter(Builder::profileIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConditionOverrides> CONDITION_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConditionOverrides").getter(BatchGetCalculatedAttributeForProfileRequest.getter(BatchGetCalculatedAttributeForProfileRequest::conditionOverrides)).setter(BatchGetCalculatedAttributeForProfileRequest.setter(Builder::conditionOverrides)).constructor(ConditionOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionOverrides").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATED_ATTRIBUTE_NAME_FIELD, DOMAIN_NAME_FIELD, PROFILE_IDS_FIELD, CONDITION_OVERRIDES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetCalculatedAttributeForProfileRequest.memberNameToFieldInitializer();
    private final String calculatedAttributeName;
    private final String domainName;
    private final List<String> profileIds;
    private final ConditionOverrides conditionOverrides;

    private BatchGetCalculatedAttributeForProfileRequest(BuilderImpl builder) {
        super(builder);
        this.calculatedAttributeName = builder.calculatedAttributeName;
        this.domainName = builder.domainName;
        this.profileIds = builder.profileIds;
        this.conditionOverrides = builder.conditionOverrides;
    }

    public final String calculatedAttributeName() {
        return this.calculatedAttributeName;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasProfileIds() {
        return this.profileIds != null && !(this.profileIds instanceof SdkAutoConstructList);
    }

    public final List<String> profileIds() {
        return this.profileIds;
    }

    public final ConditionOverrides conditionOverrides() {
        return this.conditionOverrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileIds() ? this.profileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionOverrides());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCalculatedAttributeForProfileRequest)) {
            return false;
        }
        BatchGetCalculatedAttributeForProfileRequest other = (BatchGetCalculatedAttributeForProfileRequest)((Object)obj);
        return Objects.equals(this.calculatedAttributeName(), other.calculatedAttributeName()) && Objects.equals(this.domainName(), other.domainName()) && this.hasProfileIds() == other.hasProfileIds() && Objects.equals(this.profileIds(), other.profileIds()) && Objects.equals(this.conditionOverrides(), other.conditionOverrides());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCalculatedAttributeForProfileRequest").add("CalculatedAttributeName", (Object)this.calculatedAttributeName()).add("DomainName", (Object)this.domainName()).add("ProfileIds", this.hasProfileIds() ? this.profileIds() : null).add("ConditionOverrides", (Object)(this.conditionOverrides() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CalculatedAttributeName": {
                return Optional.ofNullable(clazz.cast(this.calculatedAttributeName()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ProfileIds": {
                return Optional.ofNullable(clazz.cast(this.profileIds()));
            }
            case "ConditionOverrides": {
                return Optional.ofNullable(clazz.cast(this.conditionOverrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CalculatedAttributeName", CALCULATED_ATTRIBUTE_NAME_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ProfileIds", PROFILE_IDS_FIELD);
        map.put("ConditionOverrides", CONDITION_OVERRIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCalculatedAttributeForProfileRequest, T> g) {
        return obj -> g.apply((BatchGetCalculatedAttributeForProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String calculatedAttributeName;
        private String domainName;
        private List<String> profileIds = DefaultSdkAutoConstructList.getInstance();
        private ConditionOverrides conditionOverrides;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCalculatedAttributeForProfileRequest model) {
            super(model);
            this.calculatedAttributeName(model.calculatedAttributeName);
            this.domainName(model.domainName);
            this.profileIds(model.profileIds);
            this.conditionOverrides(model.conditionOverrides);
        }

        public final String getCalculatedAttributeName() {
            return this.calculatedAttributeName;
        }

        public final void setCalculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
        }

        @Override
        public final Builder calculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Collection<String> getProfileIds() {
            if (this.profileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.profileIds;
        }

        public final void setProfileIds(Collection<String> profileIds) {
            this.profileIds = BatchGetCalculatedAttributeForProfileIdListCopier.copy(profileIds);
        }

        @Override
        public final Builder profileIds(Collection<String> profileIds) {
            this.profileIds = BatchGetCalculatedAttributeForProfileIdListCopier.copy(profileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileIds(String ... profileIds) {
            this.profileIds(Arrays.asList(profileIds));
            return this;
        }

        public final ConditionOverrides.Builder getConditionOverrides() {
            return this.conditionOverrides != null ? this.conditionOverrides.toBuilder() : null;
        }

        public final void setConditionOverrides(ConditionOverrides.BuilderImpl conditionOverrides) {
            this.conditionOverrides = conditionOverrides != null ? conditionOverrides.build() : null;
        }

        @Override
        public final Builder conditionOverrides(ConditionOverrides conditionOverrides) {
            this.conditionOverrides = conditionOverrides;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetCalculatedAttributeForProfileRequest build() {
            return new BatchGetCalculatedAttributeForProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCalculatedAttributeForProfileRequest> {
        public Builder calculatedAttributeName(String var1);

        public Builder domainName(String var1);

        public Builder profileIds(Collection<String> var1);

        public Builder profileIds(String ... var1);

        public Builder conditionOverrides(ConditionOverrides var1);

        default public Builder conditionOverrides(Consumer<ConditionOverrides.Builder> conditionOverrides) {
            return this.conditionOverrides((ConditionOverrides)((ConditionOverrides.Builder)ConditionOverrides.builder().applyMutation(conditionOverrides)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

