/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.Status;
import software.amazon.awssdk.services.customerprofiles.model.WorkflowAttributes;
import software.amazon.awssdk.services.customerprofiles.model.WorkflowMetrics;
import software.amazon.awssdk.services.customerprofiles.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetWorkflowResponse> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowId").getter(GetWorkflowResponse.getter(GetWorkflowResponse::workflowId)).setter(GetWorkflowResponse.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowId").build()}).build();
    private static final SdkField<String> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowType").getter(GetWorkflowResponse.getter(GetWorkflowResponse::workflowTypeAsString)).setter(GetWorkflowResponse.setter(Builder::workflowType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetWorkflowResponse.getter(GetWorkflowResponse::statusAsString)).setter(GetWorkflowResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorDescription").getter(GetWorkflowResponse.getter(GetWorkflowResponse::errorDescription)).setter(GetWorkflowResponse.setter(Builder::errorDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDescription").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(GetWorkflowResponse.getter(GetWorkflowResponse::startDate)).setter(GetWorkflowResponse.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(GetWorkflowResponse.getter(GetWorkflowResponse::lastUpdatedAt)).setter(GetWorkflowResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<WorkflowAttributes> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attributes").getter(GetWorkflowResponse.getter(GetWorkflowResponse::attributes)).setter(GetWorkflowResponse.setter(Builder::attributes)).constructor(WorkflowAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build()}).build();
    private static final SdkField<WorkflowMetrics> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metrics").getter(GetWorkflowResponse.getter(GetWorkflowResponse::metrics)).setter(GetWorkflowResponse.setter(Builder::metrics)).constructor(WorkflowMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD, WORKFLOW_TYPE_FIELD, STATUS_FIELD, ERROR_DESCRIPTION_FIELD, START_DATE_FIELD, LAST_UPDATED_AT_FIELD, ATTRIBUTES_FIELD, METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWorkflowResponse.memberNameToFieldInitializer();
    private final String workflowId;
    private final String workflowType;
    private final String status;
    private final String errorDescription;
    private final Instant startDate;
    private final Instant lastUpdatedAt;
    private final WorkflowAttributes attributes;
    private final WorkflowMetrics metrics;

    private GetWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.workflowType = builder.workflowType;
        this.status = builder.status;
        this.errorDescription = builder.errorDescription;
        this.startDate = builder.startDate;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.attributes = builder.attributes;
        this.metrics = builder.metrics;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final WorkflowType workflowType() {
        return WorkflowType.fromValue(this.workflowType);
    }

    public final String workflowTypeAsString() {
        return this.workflowType;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorDescription() {
        return this.errorDescription;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final WorkflowAttributes attributes() {
        return this.attributes;
    }

    public final WorkflowMetrics metrics() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowResponse)) {
            return false;
        }
        GetWorkflowResponse other = (GetWorkflowResponse)((Object)obj);
        return Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.workflowTypeAsString(), other.workflowTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorDescription(), other.errorDescription()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.metrics(), other.metrics());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkflowResponse").add("WorkflowId", (Object)this.workflowId()).add("WorkflowType", (Object)this.workflowTypeAsString()).add("Status", (Object)this.statusAsString()).add("ErrorDescription", (Object)this.errorDescription()).add("StartDate", (Object)this.startDate()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Attributes", (Object)this.attributes()).add("Metrics", (Object)this.metrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "WorkflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorDescription": {
                return Optional.ofNullable(clazz.cast(this.errorDescription()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkflowId", WORKFLOW_ID_FIELD);
        map.put("WorkflowType", WORKFLOW_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ErrorDescription", ERROR_DESCRIPTION_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("Metrics", METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowResponse, T> g) {
        return obj -> g.apply((GetWorkflowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String workflowId;
        private String workflowType;
        private String status;
        private String errorDescription;
        private Instant startDate;
        private Instant lastUpdatedAt;
        private WorkflowAttributes attributes;
        private WorkflowMetrics metrics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowResponse model) {
            super(model);
            this.workflowId(model.workflowId);
            this.workflowType(model.workflowType);
            this.status(model.status);
            this.errorDescription(model.errorDescription);
            this.startDate(model.startDate);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.attributes(model.attributes);
            this.metrics(model.metrics);
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getWorkflowType() {
            return this.workflowType;
        }

        public final void setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public final Builder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType(workflowType == null ? null : workflowType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorDescription() {
            return this.errorDescription;
        }

        public final void setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        @Override
        public final Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final WorkflowAttributes.Builder getAttributes() {
            return this.attributes != null ? this.attributes.toBuilder() : null;
        }

        public final void setAttributes(WorkflowAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(WorkflowAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final WorkflowMetrics.Builder getMetrics() {
            return this.metrics != null ? this.metrics.toBuilder() : null;
        }

        public final void setMetrics(WorkflowMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(WorkflowMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        @Override
        public GetWorkflowResponse build() {
            return new GetWorkflowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowResponse> {
        public Builder workflowId(String var1);

        public Builder workflowType(String var1);

        public Builder workflowType(WorkflowType var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder errorDescription(String var1);

        public Builder startDate(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder attributes(WorkflowAttributes var1);

        default public Builder attributes(Consumer<WorkflowAttributes.Builder> attributes) {
            return this.attributes((WorkflowAttributes)((WorkflowAttributes.Builder)WorkflowAttributes.builder().applyMutation(attributes)).build());
        }

        public Builder metrics(WorkflowMetrics var1);

        default public Builder metrics(Consumer<WorkflowMetrics.Builder> metrics) {
            return this.metrics((WorkflowMetrics)((WorkflowMetrics.Builder)WorkflowMetrics.builder().applyMutation(metrics)).build());
        }
    }
}

