/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.LayoutType;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainLayoutResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, CreateDomainLayoutResponse> {
    private static final SdkField<String> LAYOUT_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayoutDefinitionName").getter(CreateDomainLayoutResponse.getter(CreateDomainLayoutResponse::layoutDefinitionName)).setter(CreateDomainLayoutResponse.setter(Builder::layoutDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayoutDefinitionName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateDomainLayoutResponse.getter(CreateDomainLayoutResponse::description)).setter(CreateDomainLayoutResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(CreateDomainLayoutResponse.getter(CreateDomainLayoutResponse::displayName)).setter(CreateDomainLayoutResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(CreateDomainLayoutResponse.getter(CreateDomainLayoutResponse::isDefault)).setter(CreateDomainLayoutResponse.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()}).build();
    private static final SdkField<String> LAYOUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayoutType").getter(CreateDomainLayoutResponse.getter(CreateDomainLayoutResponse::layoutTypeAsString)).setter(CreateDomainLayoutResponse.setter(Builder::layoutType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayoutType").build()}).build();
    private static final SdkField<String> LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Layout").getter(CreateDomainLayoutResponse.getter(CreateDomainLayoutResponse::layout)).setter(CreateDomainLayoutResponse.setter(Builder::layout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layout").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(CreateDomainLayoutResponse.getter(CreateDomainLayoutResponse::version)).setter(CreateDomainLayoutResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateDomainLayoutResponse.getter(CreateDomainLayoutResponse::tags)).setter(CreateDomainLayoutResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CreateDomainLayoutResponse.getter(CreateDomainLayoutResponse::createdAt)).setter(CreateDomainLayoutResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(CreateDomainLayoutResponse.getter(CreateDomainLayoutResponse::lastUpdatedAt)).setter(CreateDomainLayoutResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYOUT_DEFINITION_NAME_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, IS_DEFAULT_FIELD, LAYOUT_TYPE_FIELD, LAYOUT_FIELD, VERSION_FIELD, TAGS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDomainLayoutResponse.memberNameToFieldInitializer();
    private final String layoutDefinitionName;
    private final String description;
    private final String displayName;
    private final Boolean isDefault;
    private final String layoutType;
    private final String layout;
    private final String version;
    private final Map<String, String> tags;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;

    private CreateDomainLayoutResponse(BuilderImpl builder) {
        super(builder);
        this.layoutDefinitionName = builder.layoutDefinitionName;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.isDefault = builder.isDefault;
        this.layoutType = builder.layoutType;
        this.layout = builder.layout;
        this.version = builder.version;
        this.tags = builder.tags;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final String layoutDefinitionName() {
        return this.layoutDefinitionName;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final LayoutType layoutType() {
        return LayoutType.fromValue(this.layoutType);
    }

    public final String layoutTypeAsString() {
        return this.layoutType;
    }

    public final String layout() {
        return this.layout;
    }

    public final String version() {
        return this.version;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.layout());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainLayoutResponse)) {
            return false;
        }
        CreateDomainLayoutResponse other = (CreateDomainLayoutResponse)((Object)obj);
        return Objects.equals(this.layoutDefinitionName(), other.layoutDefinitionName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.layoutTypeAsString(), other.layoutTypeAsString()) && Objects.equals(this.layout(), other.layout()) && Objects.equals(this.version(), other.version()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDomainLayoutResponse").add("LayoutDefinitionName", (Object)this.layoutDefinitionName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)this.displayName()).add("IsDefault", (Object)this.isDefault()).add("LayoutType", (Object)this.layoutTypeAsString()).add("Layout", (Object)(this.layout() == null ? null : "*** Sensitive Data Redacted ***")).add("Version", (Object)this.version()).add("Tags", this.hasTags() ? this.tags() : null).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LayoutDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.layoutDefinitionName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "LayoutType": {
                return Optional.ofNullable(clazz.cast(this.layoutTypeAsString()));
            }
            case "Layout": {
                return Optional.ofNullable(clazz.cast(this.layout()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LayoutDefinitionName", LAYOUT_DEFINITION_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("IsDefault", IS_DEFAULT_FIELD);
        map.put("LayoutType", LAYOUT_TYPE_FIELD);
        map.put("Layout", LAYOUT_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainLayoutResponse, T> g) {
        return obj -> g.apply((CreateDomainLayoutResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String layoutDefinitionName;
        private String description;
        private String displayName;
        private Boolean isDefault;
        private String layoutType;
        private String layout;
        private String version;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdAt;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainLayoutResponse model) {
            super(model);
            this.layoutDefinitionName(model.layoutDefinitionName);
            this.description(model.description);
            this.displayName(model.displayName);
            this.isDefault(model.isDefault);
            this.layoutType(model.layoutType);
            this.layout(model.layout);
            this.version(model.version);
            this.tags(model.tags);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getLayoutDefinitionName() {
            return this.layoutDefinitionName;
        }

        public final void setLayoutDefinitionName(String layoutDefinitionName) {
            this.layoutDefinitionName = layoutDefinitionName;
        }

        @Override
        public final Builder layoutDefinitionName(String layoutDefinitionName) {
            this.layoutDefinitionName = layoutDefinitionName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getLayoutType() {
            return this.layoutType;
        }

        public final void setLayoutType(String layoutType) {
            this.layoutType = layoutType;
        }

        @Override
        public final Builder layoutType(String layoutType) {
            this.layoutType = layoutType;
            return this;
        }

        @Override
        public final Builder layoutType(LayoutType layoutType) {
            this.layoutType(layoutType == null ? null : layoutType.toString());
            return this;
        }

        public final String getLayout() {
            return this.layout;
        }

        public final void setLayout(String layout) {
            this.layout = layout;
        }

        @Override
        public final Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public CreateDomainLayoutResponse build() {
            return new CreateDomainLayoutResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainLayoutResponse> {
        public Builder layoutDefinitionName(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder isDefault(Boolean var1);

        public Builder layoutType(String var1);

        public Builder layoutType(LayoutType var1);

        public Builder layout(String var1);

        public Builder version(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

