/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.DataStoreRequest;
import software.amazon.awssdk.services.customerprofiles.model.MatchingRequest;
import software.amazon.awssdk.services.customerprofiles.model.RuleBasedMatchingRequest;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, CreateDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateDomainRequest.getter(CreateDomainRequest::domainName)).setter(CreateDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<Integer> DEFAULT_EXPIRATION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultExpirationDays").getter(CreateDomainRequest.getter(CreateDomainRequest::defaultExpirationDays)).setter(CreateDomainRequest.setter(Builder::defaultExpirationDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultExpirationDays").build()}).build();
    private static final SdkField<String> DEFAULT_ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultEncryptionKey").getter(CreateDomainRequest.getter(CreateDomainRequest::defaultEncryptionKey)).setter(CreateDomainRequest.setter(Builder::defaultEncryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEncryptionKey").build()}).build();
    private static final SdkField<String> DEAD_LETTER_QUEUE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeadLetterQueueUrl").getter(CreateDomainRequest.getter(CreateDomainRequest::deadLetterQueueUrl)).setter(CreateDomainRequest.setter(Builder::deadLetterQueueUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterQueueUrl").build()}).build();
    private static final SdkField<MatchingRequest> MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Matching").getter(CreateDomainRequest.getter(CreateDomainRequest::matching)).setter(CreateDomainRequest.setter(Builder::matching)).constructor(MatchingRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matching").build()}).build();
    private static final SdkField<RuleBasedMatchingRequest> RULE_BASED_MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuleBasedMatching").getter(CreateDomainRequest.getter(CreateDomainRequest::ruleBasedMatching)).setter(CreateDomainRequest.setter(Builder::ruleBasedMatching)).constructor(RuleBasedMatchingRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleBasedMatching").build()}).build();
    private static final SdkField<DataStoreRequest> DATA_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataStore").getter(CreateDomainRequest.getter(CreateDomainRequest::dataStore)).setter(CreateDomainRequest.setter(Builder::dataStore)).constructor(DataStoreRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStore").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateDomainRequest.getter(CreateDomainRequest::tags)).setter(CreateDomainRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DEFAULT_EXPIRATION_DAYS_FIELD, DEFAULT_ENCRYPTION_KEY_FIELD, DEAD_LETTER_QUEUE_URL_FIELD, MATCHING_FIELD, RULE_BASED_MATCHING_FIELD, DATA_STORE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDomainRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final Integer defaultExpirationDays;
    private final String defaultEncryptionKey;
    private final String deadLetterQueueUrl;
    private final MatchingRequest matching;
    private final RuleBasedMatchingRequest ruleBasedMatching;
    private final DataStoreRequest dataStore;
    private final Map<String, String> tags;

    private CreateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.defaultExpirationDays = builder.defaultExpirationDays;
        this.defaultEncryptionKey = builder.defaultEncryptionKey;
        this.deadLetterQueueUrl = builder.deadLetterQueueUrl;
        this.matching = builder.matching;
        this.ruleBasedMatching = builder.ruleBasedMatching;
        this.dataStore = builder.dataStore;
        this.tags = builder.tags;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final Integer defaultExpirationDays() {
        return this.defaultExpirationDays;
    }

    public final String defaultEncryptionKey() {
        return this.defaultEncryptionKey;
    }

    public final String deadLetterQueueUrl() {
        return this.deadLetterQueueUrl;
    }

    public final MatchingRequest matching() {
        return this.matching;
    }

    public final RuleBasedMatchingRequest ruleBasedMatching() {
        return this.ruleBasedMatching;
    }

    public final DataStoreRequest dataStore() {
        return this.dataStore;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultExpirationDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterQueueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.matching());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleBasedMatching());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainRequest)) {
            return false;
        }
        CreateDomainRequest other = (CreateDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.defaultExpirationDays(), other.defaultExpirationDays()) && Objects.equals(this.defaultEncryptionKey(), other.defaultEncryptionKey()) && Objects.equals(this.deadLetterQueueUrl(), other.deadLetterQueueUrl()) && Objects.equals(this.matching(), other.matching()) && Objects.equals(this.ruleBasedMatching(), other.ruleBasedMatching()) && Objects.equals(this.dataStore(), other.dataStore()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDomainRequest").add("DomainName", (Object)this.domainName()).add("DefaultExpirationDays", (Object)this.defaultExpirationDays()).add("DefaultEncryptionKey", (Object)this.defaultEncryptionKey()).add("DeadLetterQueueUrl", (Object)this.deadLetterQueueUrl()).add("Matching", (Object)this.matching()).add("RuleBasedMatching", (Object)this.ruleBasedMatching()).add("DataStore", (Object)this.dataStore()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DefaultExpirationDays": {
                return Optional.ofNullable(clazz.cast(this.defaultExpirationDays()));
            }
            case "DefaultEncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.defaultEncryptionKey()));
            }
            case "DeadLetterQueueUrl": {
                return Optional.ofNullable(clazz.cast(this.deadLetterQueueUrl()));
            }
            case "Matching": {
                return Optional.ofNullable(clazz.cast(this.matching()));
            }
            case "RuleBasedMatching": {
                return Optional.ofNullable(clazz.cast(this.ruleBasedMatching()));
            }
            case "DataStore": {
                return Optional.ofNullable(clazz.cast(this.dataStore()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("DefaultExpirationDays", DEFAULT_EXPIRATION_DAYS_FIELD);
        map.put("DefaultEncryptionKey", DEFAULT_ENCRYPTION_KEY_FIELD);
        map.put("DeadLetterQueueUrl", DEAD_LETTER_QUEUE_URL_FIELD);
        map.put("Matching", MATCHING_FIELD);
        map.put("RuleBasedMatching", RULE_BASED_MATCHING_FIELD);
        map.put("DataStore", DATA_STORE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainRequest, T> g) {
        return obj -> g.apply((CreateDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private Integer defaultExpirationDays;
        private String defaultEncryptionKey;
        private String deadLetterQueueUrl;
        private MatchingRequest matching;
        private RuleBasedMatchingRequest ruleBasedMatching;
        private DataStoreRequest dataStore;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.defaultExpirationDays(model.defaultExpirationDays);
            this.defaultEncryptionKey(model.defaultEncryptionKey);
            this.deadLetterQueueUrl(model.deadLetterQueueUrl);
            this.matching(model.matching);
            this.ruleBasedMatching(model.ruleBasedMatching);
            this.dataStore(model.dataStore);
            this.tags(model.tags);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Integer getDefaultExpirationDays() {
            return this.defaultExpirationDays;
        }

        public final void setDefaultExpirationDays(Integer defaultExpirationDays) {
            this.defaultExpirationDays = defaultExpirationDays;
        }

        @Override
        public final Builder defaultExpirationDays(Integer defaultExpirationDays) {
            this.defaultExpirationDays = defaultExpirationDays;
            return this;
        }

        public final String getDefaultEncryptionKey() {
            return this.defaultEncryptionKey;
        }

        public final void setDefaultEncryptionKey(String defaultEncryptionKey) {
            this.defaultEncryptionKey = defaultEncryptionKey;
        }

        @Override
        public final Builder defaultEncryptionKey(String defaultEncryptionKey) {
            this.defaultEncryptionKey = defaultEncryptionKey;
            return this;
        }

        public final String getDeadLetterQueueUrl() {
            return this.deadLetterQueueUrl;
        }

        public final void setDeadLetterQueueUrl(String deadLetterQueueUrl) {
            this.deadLetterQueueUrl = deadLetterQueueUrl;
        }

        @Override
        public final Builder deadLetterQueueUrl(String deadLetterQueueUrl) {
            this.deadLetterQueueUrl = deadLetterQueueUrl;
            return this;
        }

        public final MatchingRequest.Builder getMatching() {
            return this.matching != null ? this.matching.toBuilder() : null;
        }

        public final void setMatching(MatchingRequest.BuilderImpl matching) {
            this.matching = matching != null ? matching.build() : null;
        }

        @Override
        public final Builder matching(MatchingRequest matching) {
            this.matching = matching;
            return this;
        }

        public final RuleBasedMatchingRequest.Builder getRuleBasedMatching() {
            return this.ruleBasedMatching != null ? this.ruleBasedMatching.toBuilder() : null;
        }

        public final void setRuleBasedMatching(RuleBasedMatchingRequest.BuilderImpl ruleBasedMatching) {
            this.ruleBasedMatching = ruleBasedMatching != null ? ruleBasedMatching.build() : null;
        }

        @Override
        public final Builder ruleBasedMatching(RuleBasedMatchingRequest ruleBasedMatching) {
            this.ruleBasedMatching = ruleBasedMatching;
            return this;
        }

        public final DataStoreRequest.Builder getDataStore() {
            return this.dataStore != null ? this.dataStore.toBuilder() : null;
        }

        public final void setDataStore(DataStoreRequest.BuilderImpl dataStore) {
            this.dataStore = dataStore != null ? dataStore.build() : null;
        }

        @Override
        public final Builder dataStore(DataStoreRequest dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainRequest build() {
            return new CreateDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainRequest> {
        public Builder domainName(String var1);

        public Builder defaultExpirationDays(Integer var1);

        public Builder defaultEncryptionKey(String var1);

        public Builder deadLetterQueueUrl(String var1);

        public Builder matching(MatchingRequest var1);

        default public Builder matching(Consumer<MatchingRequest.Builder> matching) {
            return this.matching((MatchingRequest)((MatchingRequest.Builder)MatchingRequest.builder().applyMutation(matching)).build());
        }

        public Builder ruleBasedMatching(RuleBasedMatchingRequest var1);

        default public Builder ruleBasedMatching(Consumer<RuleBasedMatchingRequest.Builder> ruleBasedMatching) {
            return this.ruleBasedMatching((RuleBasedMatchingRequest)((RuleBasedMatchingRequest.Builder)RuleBasedMatchingRequest.builder().applyMutation(ruleBasedMatching)).build());
        }

        public Builder dataStore(DataStoreRequest var1);

        default public Builder dataStore(Consumer<DataStoreRequest.Builder> dataStore) {
            return this.dataStore((DataStoreRequest)((DataStoreRequest.Builder)DataStoreRequest.builder().applyMutation(dataStore)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

