/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.DomainObjectTypeField;
import software.amazon.awssdk.services.customerprofiles.model.DomainObjectTypeFieldsCopier;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDomainObjectTypeResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetDomainObjectTypeResponse> {
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectTypeName").getter(GetDomainObjectTypeResponse.getter(GetDomainObjectTypeResponse::objectTypeName)).setter(GetDomainObjectTypeResponse.setter(Builder::objectTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetDomainObjectTypeResponse.getter(GetDomainObjectTypeResponse::description)).setter(GetDomainObjectTypeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKey").getter(GetDomainObjectTypeResponse.getter(GetDomainObjectTypeResponse::encryptionKey)).setter(GetDomainObjectTypeResponse.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()}).build();
    private static final SdkField<Map<String, DomainObjectTypeField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Fields").getter(GetDomainObjectTypeResponse.getter(GetDomainObjectTypeResponse::fields)).setter(GetDomainObjectTypeResponse.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainObjectTypeField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetDomainObjectTypeResponse.getter(GetDomainObjectTypeResponse::createdAt)).setter(GetDomainObjectTypeResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(GetDomainObjectTypeResponse.getter(GetDomainObjectTypeResponse::lastUpdatedAt)).setter(GetDomainObjectTypeResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetDomainObjectTypeResponse.getter(GetDomainObjectTypeResponse::tags)).setter(GetDomainObjectTypeResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_TYPE_NAME_FIELD, DESCRIPTION_FIELD, ENCRYPTION_KEY_FIELD, FIELDS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDomainObjectTypeResponse.memberNameToFieldInitializer();
    private final String objectTypeName;
    private final String description;
    private final String encryptionKey;
    private final Map<String, DomainObjectTypeField> fields;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final Map<String, String> tags;

    private GetDomainObjectTypeResponse(BuilderImpl builder) {
        super(builder);
        this.objectTypeName = builder.objectTypeName;
        this.description = builder.description;
        this.encryptionKey = builder.encryptionKey;
        this.fields = builder.fields;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.tags = builder.tags;
    }

    public final String objectTypeName() {
        return this.objectTypeName;
    }

    public final String description() {
        return this.description;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructMap);
    }

    public final Map<String, DomainObjectTypeField> fields() {
        return this.fields;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainObjectTypeResponse)) {
            return false;
        }
        GetDomainObjectTypeResponse other = (GetDomainObjectTypeResponse)((Object)obj);
        return Objects.equals(this.objectTypeName(), other.objectTypeName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetDomainObjectTypeResponse").add("ObjectTypeName", (Object)this.objectTypeName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EncryptionKey", (Object)this.encryptionKey()).add("Fields", this.hasFields() ? this.fields() : null).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectTypeName": {
                return Optional.ofNullable(clazz.cast(this.objectTypeName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ObjectTypeName", OBJECT_TYPE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EncryptionKey", ENCRYPTION_KEY_FIELD);
        map.put("Fields", FIELDS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDomainObjectTypeResponse, T> g) {
        return obj -> g.apply((GetDomainObjectTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String objectTypeName;
        private String description;
        private String encryptionKey;
        private Map<String, DomainObjectTypeField> fields = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainObjectTypeResponse model) {
            super(model);
            this.objectTypeName(model.objectTypeName);
            this.description(model.description);
            this.encryptionKey(model.encryptionKey);
            this.fields(model.fields);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.tags(model.tags);
        }

        public final String getObjectTypeName() {
            return this.objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final Map<String, DomainObjectTypeField.Builder> getFields() {
            Map<String, DomainObjectTypeField.Builder> result = DomainObjectTypeFieldsCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, DomainObjectTypeField.BuilderImpl> fields) {
            this.fields = DomainObjectTypeFieldsCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Map<String, DomainObjectTypeField> fields) {
            this.fields = DomainObjectTypeFieldsCopier.copy(fields);
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetDomainObjectTypeResponse build() {
            return new GetDomainObjectTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDomainObjectTypeResponse> {
        public Builder objectTypeName(String var1);

        public Builder description(String var1);

        public Builder encryptionKey(String var1);

        public Builder fields(Map<String, DomainObjectTypeField> var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

