/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUploadJobPathResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetUploadJobPathResponse> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(GetUploadJobPathResponse.getter(GetUploadJobPathResponse::url)).setter(GetUploadJobPathResponse.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(GetUploadJobPathResponse.getter(GetUploadJobPathResponse::clientToken)).setter(GetUploadJobPathResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidUntil").getter(GetUploadJobPathResponse.getter(GetUploadJobPathResponse::validUntil)).setter(GetUploadJobPathResponse.setter(Builder::validUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, CLIENT_TOKEN_FIELD, VALID_UNTIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetUploadJobPathResponse.memberNameToFieldInitializer();
    private final String url;
    private final String clientToken;
    private final Instant validUntil;

    private GetUploadJobPathResponse(BuilderImpl builder) {
        super(builder);
        this.url = builder.url;
        this.clientToken = builder.clientToken;
        this.validUntil = builder.validUntil;
    }

    public final String url() {
        return this.url;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Instant validUntil() {
        return this.validUntil;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.validUntil());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUploadJobPathResponse)) {
            return false;
        }
        GetUploadJobPathResponse other = (GetUploadJobPathResponse)((Object)obj);
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.validUntil(), other.validUntil());
    }

    public final String toString() {
        return ToString.builder((String)"GetUploadJobPathResponse").add("Url", (Object)this.url()).add("ClientToken", (Object)this.clientToken()).add("ValidUntil", (Object)this.validUntil()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ValidUntil": {
                return Optional.ofNullable(clazz.cast(this.validUntil()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Url", URL_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ValidUntil", VALID_UNTIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUploadJobPathResponse, T> g) {
        return obj -> g.apply((GetUploadJobPathResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String url;
        private String clientToken;
        private Instant validUntil;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUploadJobPathResponse model) {
            super(model);
            this.url(model.url);
            this.clientToken(model.clientToken);
            this.validUntil(model.validUntil);
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        @Override
        public GetUploadJobPathResponse build() {
            return new GetUploadJobPathResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUploadJobPathResponse> {
        public Builder url(String var1);

        public Builder clientToken(String var1);

        public Builder validUntil(Instant var1);
    }
}

