/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderRecipe;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderRecipesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecommenderRecipesResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, ListRecommenderRecipesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRecommenderRecipesResponse.getter(ListRecommenderRecipesResponse::nextToken)).setter(ListRecommenderRecipesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RecommenderRecipe>> RECOMMENDER_RECIPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecommenderRecipes").getter(ListRecommenderRecipesResponse.getter(ListRecommenderRecipesResponse::recommenderRecipes)).setter(ListRecommenderRecipesResponse.setter(Builder::recommenderRecipes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderRecipes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommenderRecipe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RECOMMENDER_RECIPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRecommenderRecipesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<RecommenderRecipe> recommenderRecipes;

    private ListRecommenderRecipesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.recommenderRecipes = builder.recommenderRecipes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRecommenderRecipes() {
        return this.recommenderRecipes != null && !(this.recommenderRecipes instanceof SdkAutoConstructList);
    }

    public final List<RecommenderRecipe> recommenderRecipes() {
        return this.recommenderRecipes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommenderRecipes() ? this.recommenderRecipes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommenderRecipesResponse)) {
            return false;
        }
        ListRecommenderRecipesResponse other = (ListRecommenderRecipesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRecommenderRecipes() == other.hasRecommenderRecipes() && Objects.equals(this.recommenderRecipes(), other.recommenderRecipes());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecommenderRecipesResponse").add("NextToken", (Object)this.nextToken()).add("RecommenderRecipes", this.hasRecommenderRecipes() ? this.recommenderRecipes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RecommenderRecipes": {
                return Optional.ofNullable(clazz.cast(this.recommenderRecipes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RecommenderRecipes", RECOMMENDER_RECIPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRecommenderRecipesResponse, T> g) {
        return obj -> g.apply((ListRecommenderRecipesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RecommenderRecipe> recommenderRecipes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommenderRecipesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.recommenderRecipes(model.recommenderRecipes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RecommenderRecipe.Builder> getRecommenderRecipes() {
            List<RecommenderRecipe.Builder> result = RecommenderRecipesListCopier.copyToBuilder(this.recommenderRecipes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommenderRecipes(Collection<RecommenderRecipe.BuilderImpl> recommenderRecipes) {
            this.recommenderRecipes = RecommenderRecipesListCopier.copyFromBuilder(recommenderRecipes);
        }

        @Override
        public final Builder recommenderRecipes(Collection<RecommenderRecipe> recommenderRecipes) {
            this.recommenderRecipes = RecommenderRecipesListCopier.copy(recommenderRecipes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommenderRecipes(RecommenderRecipe ... recommenderRecipes) {
            this.recommenderRecipes(Arrays.asList(recommenderRecipes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommenderRecipes(Consumer<RecommenderRecipe.Builder> ... recommenderRecipes) {
            this.recommenderRecipes(Stream.of(recommenderRecipes).map(c -> (RecommenderRecipe)((RecommenderRecipe.Builder)RecommenderRecipe.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRecommenderRecipesResponse build() {
            return new ListRecommenderRecipesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecommenderRecipesResponse> {
        public Builder nextToken(String var1);

        public Builder recommenderRecipes(Collection<RecommenderRecipe> var1);

        public Builder recommenderRecipes(RecommenderRecipe ... var1);

        public Builder recommenderRecipes(Consumer<RecommenderRecipe.Builder> ... var1);
    }
}

