/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CatalogItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Recommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Recommendation> {
    private static final SdkField<CatalogItem> CATALOG_ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CatalogItem").getter(Recommendation.getter(Recommendation::catalogItem)).setter(Recommendation.setter(Builder::catalogItem)).constructor(CatalogItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogItem").build()}).build();
    private static final SdkField<Double> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Score").getter(Recommendation.getter(Recommendation::score)).setter(Recommendation.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ITEM_FIELD, SCORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Recommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CatalogItem catalogItem;
    private final Double score;

    private Recommendation(BuilderImpl builder) {
        this.catalogItem = builder.catalogItem;
        this.score = builder.score;
    }

    public final CatalogItem catalogItem() {
        return this.catalogItem;
    }

    public final Double score() {
        return this.score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogItem());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)obj;
        return Objects.equals(this.catalogItem(), other.catalogItem()) && Objects.equals(this.score(), other.score());
    }

    public final String toString() {
        return ToString.builder((String)"Recommendation").add("CatalogItem", (Object)this.catalogItem()).add("Score", (Object)this.score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogItem": {
                return Optional.ofNullable(clazz.cast(this.catalogItem()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CatalogItem", CATALOG_ITEM_FIELD);
        map.put("Score", SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Recommendation, T> g) {
        return obj -> g.apply((Recommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CatalogItem catalogItem;
        private Double score;

        private BuilderImpl() {
        }

        private BuilderImpl(Recommendation model) {
            this.catalogItem(model.catalogItem);
            this.score(model.score);
        }

        public final CatalogItem.Builder getCatalogItem() {
            return this.catalogItem != null ? this.catalogItem.toBuilder() : null;
        }

        public final void setCatalogItem(CatalogItem.BuilderImpl catalogItem) {
            this.catalogItem = catalogItem != null ? catalogItem.build() : null;
        }

        @Override
        public final Builder catalogItem(CatalogItem catalogItem) {
            this.catalogItem = catalogItem;
            return this;
        }

        public final Double getScore() {
            return this.score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public Recommendation build() {
            return new Recommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Recommendation> {
        public Builder catalogItem(CatalogItem var1);

        default public Builder catalogItem(Consumer<CatalogItem.Builder> catalogItem) {
            return this.catalogItem((CatalogItem)((CatalogItem.Builder)CatalogItem.builder().applyMutation(catalogItem)).build());
        }

        public Builder score(Double var1);
    }
}

