/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.EventsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommenderConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommenderConfig> {
    private static final SdkField<EventsConfig> EVENTS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventsConfig").getter(RecommenderConfig.getter(RecommenderConfig::eventsConfig)).setter(RecommenderConfig.setter(Builder::eventsConfig)).constructor(EventsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsConfig").build()}).build();
    private static final SdkField<Integer> TRAINING_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TrainingFrequency").getter(RecommenderConfig.getter(RecommenderConfig::trainingFrequency)).setter(RecommenderConfig.setter(Builder::trainingFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingFrequency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_CONFIG_FIELD, TRAINING_FREQUENCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecommenderConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EventsConfig eventsConfig;
    private final Integer trainingFrequency;

    private RecommenderConfig(BuilderImpl builder) {
        this.eventsConfig = builder.eventsConfig;
        this.trainingFrequency = builder.trainingFrequency;
    }

    public final EventsConfig eventsConfig() {
        return this.eventsConfig;
    }

    public final Integer trainingFrequency() {
        return this.trainingFrequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingFrequency());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommenderConfig)) {
            return false;
        }
        RecommenderConfig other = (RecommenderConfig)obj;
        return Objects.equals(this.eventsConfig(), other.eventsConfig()) && Objects.equals(this.trainingFrequency(), other.trainingFrequency());
    }

    public final String toString() {
        return ToString.builder((String)"RecommenderConfig").add("EventsConfig", (Object)this.eventsConfig()).add("TrainingFrequency", (Object)this.trainingFrequency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventsConfig": {
                return Optional.ofNullable(clazz.cast(this.eventsConfig()));
            }
            case "TrainingFrequency": {
                return Optional.ofNullable(clazz.cast(this.trainingFrequency()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventsConfig", EVENTS_CONFIG_FIELD);
        map.put("TrainingFrequency", TRAINING_FREQUENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommenderConfig, T> g) {
        return obj -> g.apply((RecommenderConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EventsConfig eventsConfig;
        private Integer trainingFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommenderConfig model) {
            this.eventsConfig(model.eventsConfig);
            this.trainingFrequency(model.trainingFrequency);
        }

        public final EventsConfig.Builder getEventsConfig() {
            return this.eventsConfig != null ? this.eventsConfig.toBuilder() : null;
        }

        public final void setEventsConfig(EventsConfig.BuilderImpl eventsConfig) {
            this.eventsConfig = eventsConfig != null ? eventsConfig.build() : null;
        }

        @Override
        public final Builder eventsConfig(EventsConfig eventsConfig) {
            this.eventsConfig = eventsConfig;
            return this;
        }

        public final Integer getTrainingFrequency() {
            return this.trainingFrequency;
        }

        public final void setTrainingFrequency(Integer trainingFrequency) {
            this.trainingFrequency = trainingFrequency;
        }

        @Override
        public final Builder trainingFrequency(Integer trainingFrequency) {
            this.trainingFrequency = trainingFrequency;
            return this;
        }

        public RecommenderConfig build() {
            return new RecommenderConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommenderConfig> {
        public Builder eventsConfig(EventsConfig var1);

        default public Builder eventsConfig(Consumer<EventsConfig.Builder> eventsConfig) {
            return this.eventsConfig((EventsConfig)((EventsConfig.Builder)EventsConfig.builder().applyMutation(eventsConfig)).build());
        }

        public Builder trainingFrequency(Integer var1);
    }
}

