/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.LayoutItem;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainLayoutsResponse;

public class ListDomainLayoutsIterable
implements SdkIterable<ListDomainLayoutsResponse> {
    private final CustomerProfilesClient client;
    private final ListDomainLayoutsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainLayoutsIterable(CustomerProfilesClient client, ListDomainLayoutsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDomainLayoutsResponseFetcher();
    }

    public Iterator<ListDomainLayoutsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LayoutItem> items() {
        Function<ListDomainLayoutsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDomainLayoutsResponseFetcher
    implements SyncPageFetcher<ListDomainLayoutsResponse> {
        private ListDomainLayoutsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainLayoutsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDomainLayoutsResponse nextPage(ListDomainLayoutsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainLayoutsIterable.this.client.listDomainLayouts(ListDomainLayoutsIterable.this.firstRequest);
            }
            return ListDomainLayoutsIterable.this.client.listDomainLayouts((ListDomainLayoutsRequest)((Object)ListDomainLayoutsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

