/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OracleAuthenticationMethod {
    PASSWORD("password"),
    KERBEROS("kerberos"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OracleAuthenticationMethod> VALUE_MAP;
    private final String value;

    private OracleAuthenticationMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OracleAuthenticationMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OracleAuthenticationMethod> knownValues() {
        EnumSet<OracleAuthenticationMethod> knownValues = EnumSet.allOf(OracleAuthenticationMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OracleAuthenticationMethod.class, OracleAuthenticationMethod::toString);
    }
}

