/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TablePreparationMode {
    DROP_TABLES_ON_TARGET("drop-tables-on-target"),
    TRUNCATE("truncate"),
    DO_NOTHING("do-nothing"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TablePreparationMode> VALUE_MAP;
    private final String value;

    private TablePreparationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TablePreparationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TablePreparationMode> knownValues() {
        EnumSet<TablePreparationMode> knownValues = EnumSet.allOf(TablePreparationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TablePreparationMode.class, TablePreparationMode::toString);
    }
}

