/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a set of options that define how DataBrew will read a comma-separated value (CSV) file when creating a
 * dataset from that file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CsvOptions implements SdkPojo, Serializable, ToCopyableBuilder<CsvOptions.Builder, CsvOptions> {
    private static final SdkField<String> DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Delimiter").getter(getter(CsvOptions::delimiter)).setter(setter(Builder::delimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()).build();

    private static final SdkField<Boolean> HEADER_ROW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HeaderRow").getter(getter(CsvOptions::headerRow)).setter(setter(Builder::headerRow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderRow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIMITER_FIELD,
            HEADER_ROW_FIELD));

    private static final long serialVersionUID = 1L;

    private final String delimiter;

    private final Boolean headerRow;

    private CsvOptions(BuilderImpl builder) {
        this.delimiter = builder.delimiter;
        this.headerRow = builder.headerRow;
    }

    /**
     * <p>
     * A single character that specifies the delimiter being used in the CSV file.
     * </p>
     * 
     * @return A single character that specifies the delimiter being used in the CSV file.
     */
    public final String delimiter() {
        return delimiter;
    }

    /**
     * <p>
     * A variable that specifies whether the first row in the file is parsed as the header. If this value is false,
     * column names are auto-generated.
     * </p>
     * 
     * @return A variable that specifies whether the first row in the file is parsed as the header. If this value is
     *         false, column names are auto-generated.
     */
    public final Boolean headerRow() {
        return headerRow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(headerRow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CsvOptions)) {
            return false;
        }
        CsvOptions other = (CsvOptions) obj;
        return Objects.equals(delimiter(), other.delimiter()) && Objects.equals(headerRow(), other.headerRow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CsvOptions").add("Delimiter", delimiter()).add("HeaderRow", headerRow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Delimiter":
            return Optional.ofNullable(clazz.cast(delimiter()));
        case "HeaderRow":
            return Optional.ofNullable(clazz.cast(headerRow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CsvOptions, T> g) {
        return obj -> g.apply((CsvOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CsvOptions> {
        /**
         * <p>
         * A single character that specifies the delimiter being used in the CSV file.
         * </p>
         * 
         * @param delimiter
         *        A single character that specifies the delimiter being used in the CSV file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(String delimiter);

        /**
         * <p>
         * A variable that specifies whether the first row in the file is parsed as the header. If this value is false,
         * column names are auto-generated.
         * </p>
         * 
         * @param headerRow
         *        A variable that specifies whether the first row in the file is parsed as the header. If this value is
         *        false, column names are auto-generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerRow(Boolean headerRow);
    }

    static final class BuilderImpl implements Builder {
        private String delimiter;

        private Boolean headerRow;

        private BuilderImpl() {
        }

        private BuilderImpl(CsvOptions model) {
            delimiter(model.delimiter);
            headerRow(model.headerRow);
        }

        public final String getDelimiter() {
            return delimiter;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        @Transient
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final Boolean getHeaderRow() {
            return headerRow;
        }

        public final void setHeaderRow(Boolean headerRow) {
            this.headerRow = headerRow;
        }

        @Override
        @Transient
        public final Builder headerRow(Boolean headerRow) {
            this.headerRow = headerRow;
            return this;
        }

        @Override
        public CsvOptions build() {
            return new CsvOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
