/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents all of the attributes of a DataBrew project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Project implements SdkPojo, Serializable, ToCopyableBuilder<Project.Builder, Project> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(Project::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(Project::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(Project::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(Project::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(Project::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedBy").getter(getter(Project::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Project::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RECIPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecipeName").getter(getter(Project::recipeName)).setter(setter(Builder::recipeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeName").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(Project::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<Sample> SAMPLE_FIELD = SdkField.<Sample> builder(MarshallingType.SDK_POJO).memberName("Sample")
            .getter(getter(Project::sample)).setter(setter(Builder::sample)).constructor(Sample::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sample").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Project::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(Project::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> OPENED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpenedBy").getter(getter(Project::openedBy)).setter(setter(Builder::openedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenedBy").build()).build();

    private static final SdkField<Instant> OPEN_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("OpenDate").getter(getter(Project::openDate)).setter(setter(Builder::openDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            CREATE_DATE_FIELD, CREATED_BY_FIELD, DATASET_NAME_FIELD, LAST_MODIFIED_DATE_FIELD, LAST_MODIFIED_BY_FIELD,
            NAME_FIELD, RECIPE_NAME_FIELD, RESOURCE_ARN_FIELD, SAMPLE_FIELD, TAGS_FIELD, ROLE_ARN_FIELD, OPENED_BY_FIELD,
            OPEN_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Instant createDate;

    private final String createdBy;

    private final String datasetName;

    private final Instant lastModifiedDate;

    private final String lastModifiedBy;

    private final String name;

    private final String recipeName;

    private final String resourceArn;

    private final Sample sample;

    private final Map<String, String> tags;

    private final String roleArn;

    private final String openedBy;

    private final Instant openDate;

    private Project(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.createDate = builder.createDate;
        this.createdBy = builder.createdBy;
        this.datasetName = builder.datasetName;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.name = builder.name;
        this.recipeName = builder.recipeName;
        this.resourceArn = builder.resourceArn;
        this.sample = builder.sample;
        this.tags = builder.tags;
        this.roleArn = builder.roleArn;
        this.openedBy = builder.openedBy;
        this.openDate = builder.openDate;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the project.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the project.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The date and time that the project was created.
     * </p>
     * 
     * @return The date and time that the project was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who crated the project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who crated the project.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The dataset that the project is to act upon.
     * </p>
     * 
     * @return The dataset that the project is to act upon.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The last modification date and time for the project.
     * </p>
     * 
     * @return The last modification date and time for the project.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who last modified the project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who last modified the project.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The unique name of a project.
     * </p>
     * 
     * @return The unique name of a project.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of a recipe that will be developed during a project session.
     * </p>
     * 
     * @return The name of a recipe that will be developed during a project session.
     */
    public final String recipeName() {
        return recipeName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the project.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The sample size and sampling type to apply to the data. If this parameter isn't specified, then the sample
     * consists of the first 500 rows from the dataset.
     * </p>
     * 
     * @return The sample size and sampling type to apply to the data. If this parameter isn't specified, then the
     *         sample consists of the first 500 rows from the dataset.
     */
    public final Sample sample() {
        return sample;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata tags that have been applied to the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata tags that have been applied to the project.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role that will be assumed for this project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role that will be assumed for this project.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user that opened the project for use.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user that opened the project for use.
     */
    public final String openedBy() {
        return openedBy;
    }

    /**
     * <p>
     * The date and time when the project was opened.
     * </p>
     * 
     * @return The date and time when the project was opened.
     */
    public final Instant openDate() {
        return openDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(recipeName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sample());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(openedBy());
        hashCode = 31 * hashCode + Objects.hashCode(openDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(createDate(), other.createDate())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(name(), other.name())
                && Objects.equals(recipeName(), other.recipeName()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(sample(), other.sample()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(openedBy(), other.openedBy()) && Objects.equals(openDate(), other.openDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Project").add("AccountId", accountId()).add("CreateDate", createDate())
                .add("CreatedBy", createdBy()).add("DatasetName", datasetName()).add("LastModifiedDate", lastModifiedDate())
                .add("LastModifiedBy", lastModifiedBy()).add("Name", name()).add("RecipeName", recipeName())
                .add("ResourceArn", resourceArn()).add("Sample", sample()).add("Tags", hasTags() ? tags() : null)
                .add("RoleArn", roleArn()).add("OpenedBy", openedBy()).add("OpenDate", openDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RecipeName":
            return Optional.ofNullable(clazz.cast(recipeName()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Sample":
            return Optional.ofNullable(clazz.cast(sample()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "OpenedBy":
            return Optional.ofNullable(clazz.cast(openedBy()));
        case "OpenDate":
            return Optional.ofNullable(clazz.cast(openDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Project, T> g) {
        return obj -> g.apply((Project) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Project> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the project.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account that owns the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The date and time that the project was created.
         * </p>
         * 
         * @param createDate
         *        The date and time that the project was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who crated the project.
         * </p>
         * 
         * @param createdBy
         *        The Amazon Resource Name (ARN) of the user who crated the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The dataset that the project is to act upon.
         * </p>
         * 
         * @param datasetName
         *        The dataset that the project is to act upon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The last modification date and time for the project.
         * </p>
         * 
         * @param lastModifiedDate
         *        The last modification date and time for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who last modified the project.
         * </p>
         * 
         * @param lastModifiedBy
         *        The Amazon Resource Name (ARN) of the user who last modified the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The unique name of a project.
         * </p>
         * 
         * @param name
         *        The unique name of a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of a recipe that will be developed during a project session.
         * </p>
         * 
         * @param recipeName
         *        The name of a recipe that will be developed during a project session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeName(String recipeName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the project.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The sample size and sampling type to apply to the data. If this parameter isn't specified, then the sample
         * consists of the first 500 rows from the dataset.
         * </p>
         * 
         * @param sample
         *        The sample size and sampling type to apply to the data. If this parameter isn't specified, then the
         *        sample consists of the first 500 rows from the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sample(Sample sample);

        /**
         * <p>
         * The sample size and sampling type to apply to the data. If this parameter isn't specified, then the sample
         * consists of the first 500 rows from the dataset.
         * </p>
         * This is a convenience that creates an instance of the {@link Sample.Builder} avoiding the need to create one
         * manually via {@link Sample#builder()}.
         *
         * When the {@link Consumer} completes, {@link Sample.Builder#build()} is called immediately and its result is
         * passed to {@link #sample(Sample)}.
         * 
         * @param sample
         *        a consumer that will call methods on {@link Sample.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sample(Sample)
         */
        default Builder sample(Consumer<Sample.Builder> sample) {
            return sample(Sample.builder().applyMutation(sample).build());
        }

        /**
         * <p>
         * Metadata tags that have been applied to the project.
         * </p>
         * 
         * @param tags
         *        Metadata tags that have been applied to the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role that will be assumed for this project.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role that will be assumed for this project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user that opened the project for use.
         * </p>
         * 
         * @param openedBy
         *        The Amazon Resource Name (ARN) of the user that opened the project for use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openedBy(String openedBy);

        /**
         * <p>
         * The date and time when the project was opened.
         * </p>
         * 
         * @param openDate
         *        The date and time when the project was opened.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openDate(Instant openDate);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Instant createDate;

        private String createdBy;

        private String datasetName;

        private Instant lastModifiedDate;

        private String lastModifiedBy;

        private String name;

        private String recipeName;

        private String resourceArn;

        private Sample sample;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String roleArn;

        private String openedBy;

        private Instant openDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            accountId(model.accountId);
            createDate(model.createDate);
            createdBy(model.createdBy);
            datasetName(model.datasetName);
            lastModifiedDate(model.lastModifiedDate);
            lastModifiedBy(model.lastModifiedBy);
            name(model.name);
            recipeName(model.recipeName);
            resourceArn(model.resourceArn);
            sample(model.sample);
            tags(model.tags);
            roleArn(model.roleArn);
            openedBy(model.openedBy);
            openDate(model.openDate);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        @Transient
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        @Transient
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        @Transient
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        @Transient
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        @Transient
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecipeName() {
            return recipeName;
        }

        public final void setRecipeName(String recipeName) {
            this.recipeName = recipeName;
        }

        @Override
        @Transient
        public final Builder recipeName(String recipeName) {
            this.recipeName = recipeName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Sample.Builder getSample() {
            return sample != null ? sample.toBuilder() : null;
        }

        public final void setSample(Sample.BuilderImpl sample) {
            this.sample = sample != null ? sample.build() : null;
        }

        @Override
        @Transient
        public final Builder sample(Sample sample) {
            this.sample = sample;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getOpenedBy() {
            return openedBy;
        }

        public final void setOpenedBy(String openedBy) {
            this.openedBy = openedBy;
        }

        @Override
        @Transient
        public final Builder openedBy(String openedBy) {
            this.openedBy = openedBy;
            return this;
        }

        public final Instant getOpenDate() {
            return openDate;
        }

        public final void setOpenDate(Instant openDate) {
            this.openDate = openDate;
        }

        @Override
        @Transient
        public final Builder openDate(Instant openDate) {
            this.openDate = openDate;
            return this;
        }

        @Override
        public Project build() {
            return new Project(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
