/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databrew.DataBrewAsyncClient;
import software.amazon.awssdk.services.databrew.model.JobRun;
import software.amazon.awssdk.services.databrew.model.ListJobRunsRequest;
import software.amazon.awssdk.services.databrew.model.ListJobRunsResponse;

public class ListJobRunsPublisher
implements SdkPublisher<ListJobRunsResponse> {
    private final DataBrewAsyncClient client;
    private final ListJobRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobRunsPublisher(DataBrewAsyncClient client, ListJobRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobRunsPublisher(DataBrewAsyncClient client, ListJobRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobRun> jobRuns() {
        Function<ListJobRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobRuns() != null) {
                return response.jobRuns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListJobRunsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListJobRunsResponseFetcher
    implements AsyncPageFetcher<ListJobRunsResponse> {
        private ListJobRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListJobRunsResponse> nextPage(ListJobRunsResponse previousPage) {
            if (previousPage == null) {
                return ListJobRunsPublisher.this.client.listJobRuns(ListJobRunsPublisher.this.firstRequest);
            }
            return ListJobRunsPublisher.this.client.listJobRuns((ListJobRunsRequest)((Object)ListJobRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

