/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.SheetIndexListCopier;
import software.amazon.awssdk.services.databrew.model.SheetNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExcelOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExcelOptions> {
    private static final SdkField<List<String>> SHEET_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SheetNames").getter(ExcelOptions.getter(ExcelOptions::sheetNames)).setter(ExcelOptions.setter(Builder::sheetNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> SHEET_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SheetIndexes").getter(ExcelOptions.getter(ExcelOptions::sheetIndexes)).setter(ExcelOptions.setter(Builder::sheetIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> HEADER_ROW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HeaderRow").getter(ExcelOptions.getter(ExcelOptions::headerRow)).setter(ExcelOptions.setter(Builder::headerRow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderRow").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHEET_NAMES_FIELD, SHEET_INDEXES_FIELD, HEADER_ROW_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExcelOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> sheetNames;
    private final List<Integer> sheetIndexes;
    private final Boolean headerRow;

    private ExcelOptions(BuilderImpl builder) {
        this.sheetNames = builder.sheetNames;
        this.sheetIndexes = builder.sheetIndexes;
        this.headerRow = builder.headerRow;
    }

    public final boolean hasSheetNames() {
        return this.sheetNames != null && !(this.sheetNames instanceof SdkAutoConstructList);
    }

    public final List<String> sheetNames() {
        return this.sheetNames;
    }

    public final boolean hasSheetIndexes() {
        return this.sheetIndexes != null && !(this.sheetIndexes instanceof SdkAutoConstructList);
    }

    public final List<Integer> sheetIndexes() {
        return this.sheetIndexes;
    }

    public final Boolean headerRow() {
        return this.headerRow;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSheetNames() ? this.sheetNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSheetIndexes() ? this.sheetIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.headerRow());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExcelOptions)) {
            return false;
        }
        ExcelOptions other = (ExcelOptions)obj;
        return this.hasSheetNames() == other.hasSheetNames() && Objects.equals(this.sheetNames(), other.sheetNames()) && this.hasSheetIndexes() == other.hasSheetIndexes() && Objects.equals(this.sheetIndexes(), other.sheetIndexes()) && Objects.equals(this.headerRow(), other.headerRow());
    }

    public final String toString() {
        return ToString.builder((String)"ExcelOptions").add("SheetNames", this.hasSheetNames() ? this.sheetNames() : null).add("SheetIndexes", this.hasSheetIndexes() ? this.sheetIndexes() : null).add("HeaderRow", (Object)this.headerRow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SheetNames": {
                return Optional.ofNullable(clazz.cast(this.sheetNames()));
            }
            case "SheetIndexes": {
                return Optional.ofNullable(clazz.cast(this.sheetIndexes()));
            }
            case "HeaderRow": {
                return Optional.ofNullable(clazz.cast(this.headerRow()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SheetNames", SHEET_NAMES_FIELD);
        map.put("SheetIndexes", SHEET_INDEXES_FIELD);
        map.put("HeaderRow", HEADER_ROW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExcelOptions, T> g) {
        return obj -> g.apply((ExcelOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> sheetNames = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> sheetIndexes = DefaultSdkAutoConstructList.getInstance();
        private Boolean headerRow;

        private BuilderImpl() {
        }

        private BuilderImpl(ExcelOptions model) {
            this.sheetNames(model.sheetNames);
            this.sheetIndexes(model.sheetIndexes);
            this.headerRow(model.headerRow);
        }

        public final Collection<String> getSheetNames() {
            if (this.sheetNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sheetNames;
        }

        public final void setSheetNames(Collection<String> sheetNames) {
            this.sheetNames = SheetNameListCopier.copy(sheetNames);
        }

        @Override
        public final Builder sheetNames(Collection<String> sheetNames) {
            this.sheetNames = SheetNameListCopier.copy(sheetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheetNames(String ... sheetNames) {
            this.sheetNames(Arrays.asList(sheetNames));
            return this;
        }

        public final Collection<Integer> getSheetIndexes() {
            if (this.sheetIndexes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sheetIndexes;
        }

        public final void setSheetIndexes(Collection<Integer> sheetIndexes) {
            this.sheetIndexes = SheetIndexListCopier.copy(sheetIndexes);
        }

        @Override
        public final Builder sheetIndexes(Collection<Integer> sheetIndexes) {
            this.sheetIndexes = SheetIndexListCopier.copy(sheetIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheetIndexes(Integer ... sheetIndexes) {
            this.sheetIndexes(Arrays.asList(sheetIndexes));
            return this;
        }

        public final Boolean getHeaderRow() {
            return this.headerRow;
        }

        public final void setHeaderRow(Boolean headerRow) {
            this.headerRow = headerRow;
        }

        @Override
        public final Builder headerRow(Boolean headerRow) {
            this.headerRow = headerRow;
            return this;
        }

        public ExcelOptions build() {
            return new ExcelOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExcelOptions> {
        public Builder sheetNames(Collection<String> var1);

        public Builder sheetNames(String ... var1);

        public Builder sheetIndexes(Collection<Integer> var1);

        public Builder sheetIndexes(Integer ... var1);

        public Builder headerRow(Boolean var1);
    }
}

