/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databrew.DataBrewClient;
import software.amazon.awssdk.services.databrew.internal.UserAgentUtils;
import software.amazon.awssdk.services.databrew.model.ListRecipesRequest;
import software.amazon.awssdk.services.databrew.model.ListRecipesResponse;
import software.amazon.awssdk.services.databrew.model.Recipe;

public class ListRecipesIterable
implements SdkIterable<ListRecipesResponse> {
    private final DataBrewClient client;
    private final ListRecipesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecipesIterable(DataBrewClient client, ListRecipesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecipesResponseFetcher();
    }

    public Iterator<ListRecipesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Recipe> recipes() {
        Function<ListRecipesResponse, Iterator> getIterator = response -> {
            if (response != null && response.recipes() != null) {
                return response.recipes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecipesResponseFetcher
    implements SyncPageFetcher<ListRecipesResponse> {
        private ListRecipesResponseFetcher() {
        }

        public boolean hasNextPage(ListRecipesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecipesResponse nextPage(ListRecipesResponse previousPage) {
            if (previousPage == null) {
                return ListRecipesIterable.this.client.listRecipes(ListRecipesIterable.this.firstRequest);
            }
            return ListRecipesIterable.this.client.listRecipes((ListRecipesRequest)((Object)ListRecipesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

