/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.AutoExportRevisionDestinationEntry;
import software.amazon.awssdk.services.dataexchange.model.ExportServerSideEncryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoExportRevisionToS3RequestDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoExportRevisionToS3RequestDetails> {
    private static final SdkField<ExportServerSideEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(AutoExportRevisionToS3RequestDetails.getter(AutoExportRevisionToS3RequestDetails::encryption)).setter(AutoExportRevisionToS3RequestDetails.setter(Builder::encryption)).constructor(ExportServerSideEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()}).build();
    private static final SdkField<AutoExportRevisionDestinationEntry> REVISION_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RevisionDestination").getter(AutoExportRevisionToS3RequestDetails.getter(AutoExportRevisionToS3RequestDetails::revisionDestination)).setter(AutoExportRevisionToS3RequestDetails.setter(Builder::revisionDestination)).constructor(AutoExportRevisionDestinationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD, REVISION_DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoExportRevisionToS3RequestDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ExportServerSideEncryption encryption;
    private final AutoExportRevisionDestinationEntry revisionDestination;

    private AutoExportRevisionToS3RequestDetails(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.revisionDestination = builder.revisionDestination;
    }

    public final ExportServerSideEncryption encryption() {
        return this.encryption;
    }

    public final AutoExportRevisionDestinationEntry revisionDestination() {
        return this.revisionDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionDestination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoExportRevisionToS3RequestDetails)) {
            return false;
        }
        AutoExportRevisionToS3RequestDetails other = (AutoExportRevisionToS3RequestDetails)obj;
        return Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.revisionDestination(), other.revisionDestination());
    }

    public final String toString() {
        return ToString.builder((String)"AutoExportRevisionToS3RequestDetails").add("Encryption", (Object)this.encryption()).add("RevisionDestination", (Object)this.revisionDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "RevisionDestination": {
                return Optional.ofNullable(clazz.cast(this.revisionDestination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Encryption", ENCRYPTION_FIELD);
        map.put("RevisionDestination", REVISION_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoExportRevisionToS3RequestDetails, T> g) {
        return obj -> g.apply((AutoExportRevisionToS3RequestDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ExportServerSideEncryption encryption;
        private AutoExportRevisionDestinationEntry revisionDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoExportRevisionToS3RequestDetails model) {
            this.encryption(model.encryption);
            this.revisionDestination(model.revisionDestination);
        }

        public final ExportServerSideEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        public final void setEncryption(ExportServerSideEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(ExportServerSideEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final AutoExportRevisionDestinationEntry.Builder getRevisionDestination() {
            return this.revisionDestination != null ? this.revisionDestination.toBuilder() : null;
        }

        public final void setRevisionDestination(AutoExportRevisionDestinationEntry.BuilderImpl revisionDestination) {
            this.revisionDestination = revisionDestination != null ? revisionDestination.build() : null;
        }

        @Override
        public final Builder revisionDestination(AutoExportRevisionDestinationEntry revisionDestination) {
            this.revisionDestination = revisionDestination;
            return this;
        }

        public AutoExportRevisionToS3RequestDetails build() {
            return new AutoExportRevisionToS3RequestDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoExportRevisionToS3RequestDetails> {
        public Builder encryption(ExportServerSideEncryption var1);

        default public Builder encryption(Consumer<ExportServerSideEncryption.Builder> encryption) {
            return this.encryption((ExportServerSideEncryption)((ExportServerSideEncryption.Builder)ExportServerSideEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder revisionDestination(AutoExportRevisionDestinationEntry var1);

        default public Builder revisionDestination(Consumer<AutoExportRevisionDestinationEntry.Builder> revisionDestination) {
            return this.revisionDestination((AutoExportRevisionDestinationEntry)((AutoExportRevisionDestinationEntry.Builder)AutoExportRevisionDestinationEntry.builder().applyMutation(revisionDestination)).build());
        }
    }
}

