/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.ExportServerSideEncryption;
import software.amazon.awssdk.services.dataexchange.model.ListOfRevisionDestinationEntryCopier;
import software.amazon.awssdk.services.dataexchange.model.RevisionDestinationEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportRevisionsToS3ResponseDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportRevisionsToS3ResponseDetails> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(ExportRevisionsToS3ResponseDetails.getter(ExportRevisionsToS3ResponseDetails::dataSetId)).setter(ExportRevisionsToS3ResponseDetails.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<ExportServerSideEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(ExportRevisionsToS3ResponseDetails.getter(ExportRevisionsToS3ResponseDetails::encryption)).setter(ExportRevisionsToS3ResponseDetails.setter(Builder::encryption)).constructor(ExportServerSideEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()}).build();
    private static final SdkField<List<RevisionDestinationEntry>> REVISION_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RevisionDestinations").getter(ExportRevisionsToS3ResponseDetails.getter(ExportRevisionsToS3ResponseDetails::revisionDestinations)).setter(ExportRevisionsToS3ResponseDetails.setter(Builder::revisionDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RevisionDestinationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVENT_ACTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventActionArn").getter(ExportRevisionsToS3ResponseDetails.getter(ExportRevisionsToS3ResponseDetails::eventActionArn)).setter(ExportRevisionsToS3ResponseDetails.setter(Builder::eventActionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventActionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD, ENCRYPTION_FIELD, REVISION_DESTINATIONS_FIELD, EVENT_ACTION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportRevisionsToS3ResponseDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataSetId;
    private final ExportServerSideEncryption encryption;
    private final List<RevisionDestinationEntry> revisionDestinations;
    private final String eventActionArn;

    private ExportRevisionsToS3ResponseDetails(BuilderImpl builder) {
        this.dataSetId = builder.dataSetId;
        this.encryption = builder.encryption;
        this.revisionDestinations = builder.revisionDestinations;
        this.eventActionArn = builder.eventActionArn;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final ExportServerSideEncryption encryption() {
        return this.encryption;
    }

    public final boolean hasRevisionDestinations() {
        return this.revisionDestinations != null && !(this.revisionDestinations instanceof SdkAutoConstructList);
    }

    public final List<RevisionDestinationEntry> revisionDestinations() {
        return this.revisionDestinations;
    }

    public final String eventActionArn() {
        return this.eventActionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevisionDestinations() ? this.revisionDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventActionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportRevisionsToS3ResponseDetails)) {
            return false;
        }
        ExportRevisionsToS3ResponseDetails other = (ExportRevisionsToS3ResponseDetails)obj;
        return Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.encryption(), other.encryption()) && this.hasRevisionDestinations() == other.hasRevisionDestinations() && Objects.equals(this.revisionDestinations(), other.revisionDestinations()) && Objects.equals(this.eventActionArn(), other.eventActionArn());
    }

    public final String toString() {
        return ToString.builder((String)"ExportRevisionsToS3ResponseDetails").add("DataSetId", (Object)this.dataSetId()).add("Encryption", (Object)this.encryption()).add("RevisionDestinations", this.hasRevisionDestinations() ? this.revisionDestinations() : null).add("EventActionArn", (Object)this.eventActionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "RevisionDestinations": {
                return Optional.ofNullable(clazz.cast(this.revisionDestinations()));
            }
            case "EventActionArn": {
                return Optional.ofNullable(clazz.cast(this.eventActionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataSetId", DATA_SET_ID_FIELD);
        map.put("Encryption", ENCRYPTION_FIELD);
        map.put("RevisionDestinations", REVISION_DESTINATIONS_FIELD);
        map.put("EventActionArn", EVENT_ACTION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportRevisionsToS3ResponseDetails, T> g) {
        return obj -> g.apply((ExportRevisionsToS3ResponseDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSetId;
        private ExportServerSideEncryption encryption;
        private List<RevisionDestinationEntry> revisionDestinations = DefaultSdkAutoConstructList.getInstance();
        private String eventActionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportRevisionsToS3ResponseDetails model) {
            this.dataSetId(model.dataSetId);
            this.encryption(model.encryption);
            this.revisionDestinations(model.revisionDestinations);
            this.eventActionArn(model.eventActionArn);
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final ExportServerSideEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        public final void setEncryption(ExportServerSideEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(ExportServerSideEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final List<RevisionDestinationEntry.Builder> getRevisionDestinations() {
            List<RevisionDestinationEntry.Builder> result = ListOfRevisionDestinationEntryCopier.copyToBuilder(this.revisionDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevisionDestinations(Collection<RevisionDestinationEntry.BuilderImpl> revisionDestinations) {
            this.revisionDestinations = ListOfRevisionDestinationEntryCopier.copyFromBuilder(revisionDestinations);
        }

        @Override
        public final Builder revisionDestinations(Collection<RevisionDestinationEntry> revisionDestinations) {
            this.revisionDestinations = ListOfRevisionDestinationEntryCopier.copy(revisionDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionDestinations(RevisionDestinationEntry ... revisionDestinations) {
            this.revisionDestinations(Arrays.asList(revisionDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionDestinations(Consumer<RevisionDestinationEntry.Builder> ... revisionDestinations) {
            this.revisionDestinations(Stream.of(revisionDestinations).map(c -> (RevisionDestinationEntry)((RevisionDestinationEntry.Builder)RevisionDestinationEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEventActionArn() {
            return this.eventActionArn;
        }

        public final void setEventActionArn(String eventActionArn) {
            this.eventActionArn = eventActionArn;
        }

        @Override
        public final Builder eventActionArn(String eventActionArn) {
            this.eventActionArn = eventActionArn;
            return this;
        }

        public ExportRevisionsToS3ResponseDetails build() {
            return new ExportRevisionsToS3ResponseDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportRevisionsToS3ResponseDetails> {
        public Builder dataSetId(String var1);

        public Builder encryption(ExportServerSideEncryption var1);

        default public Builder encryption(Consumer<ExportServerSideEncryption.Builder> encryption) {
            return this.encryption((ExportServerSideEncryption)((ExportServerSideEncryption.Builder)ExportServerSideEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder revisionDestinations(Collection<RevisionDestinationEntry> var1);

        public Builder revisionDestinations(RevisionDestinationEntry ... var1);

        public Builder revisionDestinations(Consumer<RevisionDestinationEntry.Builder> ... var1);

        public Builder eventActionArn(String var1);
    }
}

