/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.DatabaseLFTagPolicy;
import software.amazon.awssdk.services.dataexchange.model.TableLFTagPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LFResourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LFResourceDetails> {
    private static final SdkField<DatabaseLFTagPolicy> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Database").getter(LFResourceDetails.getter(LFResourceDetails::database)).setter(LFResourceDetails.setter(Builder::database)).constructor(DatabaseLFTagPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<TableLFTagPolicy> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Table").getter(LFResourceDetails.getter(LFResourceDetails::table)).setter(LFResourceDetails.setter(Builder::table)).constructor(TableLFTagPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_FIELD, TABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LFResourceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DatabaseLFTagPolicy database;
    private final TableLFTagPolicy table;

    private LFResourceDetails(BuilderImpl builder) {
        this.database = builder.database;
        this.table = builder.table;
    }

    public final DatabaseLFTagPolicy database() {
        return this.database;
    }

    public final TableLFTagPolicy table() {
        return this.table;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LFResourceDetails)) {
            return false;
        }
        LFResourceDetails other = (LFResourceDetails)obj;
        return Objects.equals(this.database(), other.database()) && Objects.equals(this.table(), other.table());
    }

    public final String toString() {
        return ToString.builder((String)"LFResourceDetails").add("Database", (Object)this.database()).add("Table", (Object)this.table()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Database", DATABASE_FIELD);
        map.put("Table", TABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LFResourceDetails, T> g) {
        return obj -> g.apply((LFResourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DatabaseLFTagPolicy database;
        private TableLFTagPolicy table;

        private BuilderImpl() {
        }

        private BuilderImpl(LFResourceDetails model) {
            this.database(model.database);
            this.table(model.table);
        }

        public final DatabaseLFTagPolicy.Builder getDatabase() {
            return this.database != null ? this.database.toBuilder() : null;
        }

        public final void setDatabase(DatabaseLFTagPolicy.BuilderImpl database) {
            this.database = database != null ? database.build() : null;
        }

        @Override
        public final Builder database(DatabaseLFTagPolicy database) {
            this.database = database;
            return this;
        }

        public final TableLFTagPolicy.Builder getTable() {
            return this.table != null ? this.table.toBuilder() : null;
        }

        public final void setTable(TableLFTagPolicy.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        public final Builder table(TableLFTagPolicy table) {
            this.table = table;
            return this;
        }

        public LFResourceDetails build() {
            return new LFResourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LFResourceDetails> {
        public Builder database(DatabaseLFTagPolicy var1);

        default public Builder database(Consumer<DatabaseLFTagPolicy.Builder> database) {
            return this.database((DatabaseLFTagPolicy)((DatabaseLFTagPolicy.Builder)DatabaseLFTagPolicy.builder().applyMutation(database)).build());
        }

        public Builder table(TableLFTagPolicy var1);

        default public Builder table(Consumer<TableLFTagPolicy.Builder> table) {
            return this.table((TableLFTagPolicy)((TableLFTagPolicy.Builder)TableLFTagPolicy.builder().applyMutation(table)).build());
        }
    }
}

