/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dataexchange.DataExchangeAsyncClient;
import software.amazon.awssdk.services.dataexchange.internal.UserAgentUtils;
import software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsResponse;
import software.amazon.awssdk.services.dataexchange.model.RevisionEntry;

public class ListDataSetRevisionsPublisher
implements SdkPublisher<ListDataSetRevisionsResponse> {
    private final DataExchangeAsyncClient client;
    private final ListDataSetRevisionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataSetRevisionsPublisher(DataExchangeAsyncClient client, ListDataSetRevisionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataSetRevisionsPublisher(DataExchangeAsyncClient client, ListDataSetRevisionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataSetRevisionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataSetRevisionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RevisionEntry> revisions() {
        Function<ListDataSetRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.revisions() != null) {
                return response.revisions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataSetRevisionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataSetRevisionsResponseFetcher
    implements AsyncPageFetcher<ListDataSetRevisionsResponse> {
        private ListDataSetRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSetRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataSetRevisionsResponse> nextPage(ListDataSetRevisionsResponse previousPage) {
            if (previousPage == null) {
                return ListDataSetRevisionsPublisher.this.client.listDataSetRevisions(ListDataSetRevisionsPublisher.this.firstRequest);
            }
            return ListDataSetRevisionsPublisher.this.client.listDataSetRevisions((ListDataSetRevisionsRequest)((Object)ListDataSetRevisionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

