/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeRequest;
import software.amazon.awssdk.services.dataexchange.model.GrantDistributionScope;
import software.amazon.awssdk.services.dataexchange.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataGrantRequest
extends DataExchangeRequest
implements ToCopyableBuilder<Builder, CreateDataGrantRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateDataGrantRequest.getter(CreateDataGrantRequest::name)).setter(CreateDataGrantRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> GRANT_DISTRIBUTION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantDistributionScope").getter(CreateDataGrantRequest.getter(CreateDataGrantRequest::grantDistributionScopeAsString)).setter(CreateDataGrantRequest.setter(Builder::grantDistributionScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantDistributionScope").build()}).build();
    private static final SdkField<String> RECEIVER_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReceiverPrincipal").getter(CreateDataGrantRequest.getter(CreateDataGrantRequest::receiverPrincipal)).setter(CreateDataGrantRequest.setter(Builder::receiverPrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiverPrincipal").build()}).build();
    private static final SdkField<String> SOURCE_DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDataSetId").getter(CreateDataGrantRequest.getter(CreateDataGrantRequest::sourceDataSetId)).setter(CreateDataGrantRequest.setter(Builder::sourceDataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDataSetId").build()}).build();
    private static final SdkField<Instant> ENDS_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndsAt").getter(CreateDataGrantRequest.getter(CreateDataGrantRequest::endsAt)).setter(CreateDataGrantRequest.setter(Builder::endsAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndsAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateDataGrantRequest.getter(CreateDataGrantRequest::description)).setter(CreateDataGrantRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateDataGrantRequest.getter(CreateDataGrantRequest::tags)).setter(CreateDataGrantRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, GRANT_DISTRIBUTION_SCOPE_FIELD, RECEIVER_PRINCIPAL_FIELD, SOURCE_DATA_SET_ID_FIELD, ENDS_AT_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataGrantRequest.memberNameToFieldInitializer();
    private final String name;
    private final String grantDistributionScope;
    private final String receiverPrincipal;
    private final String sourceDataSetId;
    private final Instant endsAt;
    private final String description;
    private final Map<String, String> tags;

    private CreateDataGrantRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.grantDistributionScope = builder.grantDistributionScope;
        this.receiverPrincipal = builder.receiverPrincipal;
        this.sourceDataSetId = builder.sourceDataSetId;
        this.endsAt = builder.endsAt;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final GrantDistributionScope grantDistributionScope() {
        return GrantDistributionScope.fromValue(this.grantDistributionScope);
    }

    public final String grantDistributionScopeAsString() {
        return this.grantDistributionScope;
    }

    public final String receiverPrincipal() {
        return this.receiverPrincipal;
    }

    public final String sourceDataSetId() {
        return this.sourceDataSetId;
    }

    public final Instant endsAt() {
        return this.endsAt;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantDistributionScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiverPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endsAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataGrantRequest)) {
            return false;
        }
        CreateDataGrantRequest other = (CreateDataGrantRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.grantDistributionScopeAsString(), other.grantDistributionScopeAsString()) && Objects.equals(this.receiverPrincipal(), other.receiverPrincipal()) && Objects.equals(this.sourceDataSetId(), other.sourceDataSetId()) && Objects.equals(this.endsAt(), other.endsAt()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataGrantRequest").add("Name", (Object)this.name()).add("GrantDistributionScope", (Object)this.grantDistributionScopeAsString()).add("ReceiverPrincipal", (Object)this.receiverPrincipal()).add("SourceDataSetId", (Object)this.sourceDataSetId()).add("EndsAt", (Object)this.endsAt()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "GrantDistributionScope": {
                return Optional.ofNullable(clazz.cast(this.grantDistributionScopeAsString()));
            }
            case "ReceiverPrincipal": {
                return Optional.ofNullable(clazz.cast(this.receiverPrincipal()));
            }
            case "SourceDataSetId": {
                return Optional.ofNullable(clazz.cast(this.sourceDataSetId()));
            }
            case "EndsAt": {
                return Optional.ofNullable(clazz.cast(this.endsAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("GrantDistributionScope", GRANT_DISTRIBUTION_SCOPE_FIELD);
        map.put("ReceiverPrincipal", RECEIVER_PRINCIPAL_FIELD);
        map.put("SourceDataSetId", SOURCE_DATA_SET_ID_FIELD);
        map.put("EndsAt", ENDS_AT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataGrantRequest, T> g) {
        return obj -> g.apply((CreateDataGrantRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeRequest.BuilderImpl
    implements Builder {
        private String name;
        private String grantDistributionScope;
        private String receiverPrincipal;
        private String sourceDataSetId;
        private Instant endsAt;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataGrantRequest model) {
            super(model);
            this.name(model.name);
            this.grantDistributionScope(model.grantDistributionScope);
            this.receiverPrincipal(model.receiverPrincipal);
            this.sourceDataSetId(model.sourceDataSetId);
            this.endsAt(model.endsAt);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getGrantDistributionScope() {
            return this.grantDistributionScope;
        }

        public final void setGrantDistributionScope(String grantDistributionScope) {
            this.grantDistributionScope = grantDistributionScope;
        }

        @Override
        public final Builder grantDistributionScope(String grantDistributionScope) {
            this.grantDistributionScope = grantDistributionScope;
            return this;
        }

        @Override
        public final Builder grantDistributionScope(GrantDistributionScope grantDistributionScope) {
            this.grantDistributionScope(grantDistributionScope == null ? null : grantDistributionScope.toString());
            return this;
        }

        public final String getReceiverPrincipal() {
            return this.receiverPrincipal;
        }

        public final void setReceiverPrincipal(String receiverPrincipal) {
            this.receiverPrincipal = receiverPrincipal;
        }

        @Override
        public final Builder receiverPrincipal(String receiverPrincipal) {
            this.receiverPrincipal = receiverPrincipal;
            return this;
        }

        public final String getSourceDataSetId() {
            return this.sourceDataSetId;
        }

        public final void setSourceDataSetId(String sourceDataSetId) {
            this.sourceDataSetId = sourceDataSetId;
        }

        @Override
        public final Builder sourceDataSetId(String sourceDataSetId) {
            this.sourceDataSetId = sourceDataSetId;
            return this;
        }

        public final Instant getEndsAt() {
            return this.endsAt;
        }

        public final void setEndsAt(Instant endsAt) {
            this.endsAt = endsAt;
        }

        @Override
        public final Builder endsAt(Instant endsAt) {
            this.endsAt = endsAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataGrantRequest build() {
            return new CreateDataGrantRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataExchangeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataGrantRequest> {
        public Builder name(String var1);

        public Builder grantDistributionScope(String var1);

        public Builder grantDistributionScope(GrantDistributionScope var1);

        public Builder receiverPrincipal(String var1);

        public Builder sourceDataSetId(String var1);

        public Builder endsAt(Instant var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

