/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocationHdfsResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeLocationHdfsResponse.Builder, DescribeLocationHdfsResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(DescribeLocationHdfsResponse::locationArn))
            .setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationUri").getter(getter(DescribeLocationHdfsResponse::locationUri))
            .setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<List<HdfsNameNode>> NAME_NODES_FIELD = SdkField
            .<List<HdfsNameNode>> builder(MarshallingType.LIST)
            .memberName("NameNodes")
            .getter(getter(DescribeLocationHdfsResponse::nameNodes))
            .setter(setter(Builder::nameNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameNodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HdfsNameNode> builder(MarshallingType.SDK_POJO)
                                            .constructor(HdfsNameNode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> BLOCK_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BlockSize").getter(getter(DescribeLocationHdfsResponse::blockSize)).setter(setter(Builder::blockSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockSize").build()).build();

    private static final SdkField<Integer> REPLICATION_FACTOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReplicationFactor").getter(getter(DescribeLocationHdfsResponse::replicationFactor))
            .setter(setter(Builder::replicationFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationFactor").build()).build();

    private static final SdkField<String> KMS_KEY_PROVIDER_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyProviderUri").getter(getter(DescribeLocationHdfsResponse::kmsKeyProviderUri))
            .setter(setter(Builder::kmsKeyProviderUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyProviderUri").build()).build();

    private static final SdkField<QopConfiguration> QOP_CONFIGURATION_FIELD = SdkField
            .<QopConfiguration> builder(MarshallingType.SDK_POJO).memberName("QopConfiguration")
            .getter(getter(DescribeLocationHdfsResponse::qopConfiguration)).setter(setter(Builder::qopConfiguration))
            .constructor(QopConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QopConfiguration").build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(DescribeLocationHdfsResponse::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<String> SIMPLE_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SimpleUser").getter(getter(DescribeLocationHdfsResponse::simpleUser))
            .setter(setter(Builder::simpleUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimpleUser").build()).build();

    private static final SdkField<String> KERBEROS_PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KerberosPrincipal").getter(getter(DescribeLocationHdfsResponse::kerberosPrincipal))
            .setter(setter(Builder::kerberosPrincipal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KerberosPrincipal").build()).build();

    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AgentArns")
            .getter(getter(DescribeLocationHdfsResponse::agentArns))
            .setter(setter(Builder::agentArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeLocationHdfsResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            LOCATION_URI_FIELD, NAME_NODES_FIELD, BLOCK_SIZE_FIELD, REPLICATION_FACTOR_FIELD, KMS_KEY_PROVIDER_URI_FIELD,
            QOP_CONFIGURATION_FIELD, AUTHENTICATION_TYPE_FIELD, SIMPLE_USER_FIELD, KERBEROS_PRINCIPAL_FIELD, AGENT_ARNS_FIELD,
            CREATION_TIME_FIELD));

    private final String locationArn;

    private final String locationUri;

    private final List<HdfsNameNode> nameNodes;

    private final Integer blockSize;

    private final Integer replicationFactor;

    private final String kmsKeyProviderUri;

    private final QopConfiguration qopConfiguration;

    private final String authenticationType;

    private final String simpleUser;

    private final String kerberosPrincipal;

    private final List<String> agentArns;

    private final Instant creationTime;

    private DescribeLocationHdfsResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.nameNodes = builder.nameNodes;
        this.blockSize = builder.blockSize;
        this.replicationFactor = builder.replicationFactor;
        this.kmsKeyProviderUri = builder.kmsKeyProviderUri;
        this.qopConfiguration = builder.qopConfiguration;
        this.authenticationType = builder.authenticationType;
        this.simpleUser = builder.simpleUser;
        this.kerberosPrincipal = builder.kerberosPrincipal;
        this.agentArns = builder.agentArns;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The ARN of the HDFS cluster location.
     * </p>
     * 
     * @return The ARN of the HDFS cluster location.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * The URI of the HDFS cluster location.
     * </p>
     * 
     * @return The URI of the HDFS cluster location.
     */
    public final String locationUri() {
        return locationUri;
    }

    /**
     * For responses, this returns true if the service returned a value for the NameNodes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNameNodes() {
        return nameNodes != null && !(nameNodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The NameNode that manage the HDFS namespace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNameNodes} method.
     * </p>
     * 
     * @return The NameNode that manage the HDFS namespace.
     */
    public final List<HdfsNameNode> nameNodes() {
        return nameNodes;
    }

    /**
     * <p>
     * The size of the data blocks to write into the HDFS cluster.
     * </p>
     * 
     * @return The size of the data blocks to write into the HDFS cluster.
     */
    public final Integer blockSize() {
        return blockSize;
    }

    /**
     * <p>
     * The number of DataNodes to replicate the data to when writing to the HDFS cluster.
     * </p>
     * 
     * @return The number of DataNodes to replicate the data to when writing to the HDFS cluster.
     */
    public final Integer replicationFactor() {
        return replicationFactor;
    }

    /**
     * <p>
     * The URI of the HDFS cluster's Key Management Server (KMS).
     * </p>
     * 
     * @return The URI of the HDFS cluster's Key Management Server (KMS).
     */
    public final String kmsKeyProviderUri() {
        return kmsKeyProviderUri;
    }

    /**
     * <p>
     * The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer
     * protection settings configured on the Hadoop Distributed File System (HDFS) cluster.
     * </p>
     * 
     * @return The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer
     *         protection settings configured on the Hadoop Distributed File System (HDFS) cluster.
     */
    public final QopConfiguration qopConfiguration() {
        return qopConfiguration;
    }

    /**
     * <p>
     * The type of authentication used to determine the identity of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link HdfsAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of authentication used to determine the identity of the user.
     * @see HdfsAuthenticationType
     */
    public final HdfsAuthenticationType authenticationType() {
        return HdfsAuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The type of authentication used to determine the identity of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link HdfsAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of authentication used to determine the identity of the user.
     * @see HdfsAuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The user name used to identify the client on the host operating system. This parameter is used if the
     * <code>AuthenticationType</code> is defined as <code>SIMPLE</code>.
     * </p>
     * 
     * @return The user name used to identify the client on the host operating system. This parameter is used if the
     *         <code>AuthenticationType</code> is defined as <code>SIMPLE</code>.
     */
    public final String simpleUser() {
        return simpleUser;
    }

    /**
     * <p>
     * The Kerberos principal with access to the files and folders on the HDFS cluster. This parameter is used if the
     * <code>AuthenticationType</code> is defined as <code>KERBEROS</code>.
     * </p>
     * 
     * @return The Kerberos principal with access to the files and folders on the HDFS cluster. This parameter is used
     *         if the <code>AuthenticationType</code> is defined as <code>KERBEROS</code>.
     */
    public final String kerberosPrincipal() {
        return kerberosPrincipal;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAgentArns() {
        return agentArns != null && !(agentArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the agents that are used to connect to the HDFS cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentArns} method.
     * </p>
     * 
     * @return The ARNs of the agents that are used to connect to the HDFS cluster.
     */
    public final List<String> agentArns() {
        return agentArns;
    }

    /**
     * <p>
     * The time that the HDFS location was created.
     * </p>
     * 
     * @return The time that the HDFS location was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(hasNameNodes() ? nameNodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(blockSize());
        hashCode = 31 * hashCode + Objects.hashCode(replicationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyProviderUri());
        hashCode = 31 * hashCode + Objects.hashCode(qopConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(simpleUser());
        hashCode = 31 * hashCode + Objects.hashCode(kerberosPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentArns() ? agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationHdfsResponse)) {
            return false;
        }
        DescribeLocationHdfsResponse other = (DescribeLocationHdfsResponse) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(locationUri(), other.locationUri())
                && hasNameNodes() == other.hasNameNodes() && Objects.equals(nameNodes(), other.nameNodes())
                && Objects.equals(blockSize(), other.blockSize())
                && Objects.equals(replicationFactor(), other.replicationFactor())
                && Objects.equals(kmsKeyProviderUri(), other.kmsKeyProviderUri())
                && Objects.equals(qopConfiguration(), other.qopConfiguration())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(simpleUser(), other.simpleUser())
                && Objects.equals(kerberosPrincipal(), other.kerberosPrincipal()) && hasAgentArns() == other.hasAgentArns()
                && Objects.equals(agentArns(), other.agentArns()) && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLocationHdfsResponse").add("LocationArn", locationArn())
                .add("LocationUri", locationUri()).add("NameNodes", hasNameNodes() ? nameNodes() : null)
                .add("BlockSize", blockSize()).add("ReplicationFactor", replicationFactor())
                .add("KmsKeyProviderUri", kmsKeyProviderUri()).add("QopConfiguration", qopConfiguration())
                .add("AuthenticationType", authenticationTypeAsString()).add("SimpleUser", simpleUser())
                .add("KerberosPrincipal", kerberosPrincipal()).add("AgentArns", hasAgentArns() ? agentArns() : null)
                .add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "NameNodes":
            return Optional.ofNullable(clazz.cast(nameNodes()));
        case "BlockSize":
            return Optional.ofNullable(clazz.cast(blockSize()));
        case "ReplicationFactor":
            return Optional.ofNullable(clazz.cast(replicationFactor()));
        case "KmsKeyProviderUri":
            return Optional.ofNullable(clazz.cast(kmsKeyProviderUri()));
        case "QopConfiguration":
            return Optional.ofNullable(clazz.cast(qopConfiguration()));
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "SimpleUser":
            return Optional.ofNullable(clazz.cast(simpleUser()));
        case "KerberosPrincipal":
            return Optional.ofNullable(clazz.cast(kerberosPrincipal()));
        case "AgentArns":
            return Optional.ofNullable(clazz.cast(agentArns()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationHdfsResponse, T> g) {
        return obj -> g.apply((DescribeLocationHdfsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLocationHdfsResponse> {
        /**
         * <p>
         * The ARN of the HDFS cluster location.
         * </p>
         * 
         * @param locationArn
         *        The ARN of the HDFS cluster location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * The URI of the HDFS cluster location.
         * </p>
         * 
         * @param locationUri
         *        The URI of the HDFS cluster location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * <p>
         * The NameNode that manage the HDFS namespace.
         * </p>
         * 
         * @param nameNodes
         *        The NameNode that manage the HDFS namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameNodes(Collection<HdfsNameNode> nameNodes);

        /**
         * <p>
         * The NameNode that manage the HDFS namespace.
         * </p>
         * 
         * @param nameNodes
         *        The NameNode that manage the HDFS namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameNodes(HdfsNameNode... nameNodes);

        /**
         * <p>
         * The NameNode that manage the HDFS namespace.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HdfsNameNode>.Builder} avoiding the need to
         * create one manually via {@link List<HdfsNameNode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HdfsNameNode>.Builder#build()} is called immediately and its
         * result is passed to {@link #nameNodes(List<HdfsNameNode>)}.
         * 
         * @param nameNodes
         *        a consumer that will call methods on {@link List<HdfsNameNode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nameNodes(List<HdfsNameNode>)
         */
        Builder nameNodes(Consumer<HdfsNameNode.Builder>... nameNodes);

        /**
         * <p>
         * The size of the data blocks to write into the HDFS cluster.
         * </p>
         * 
         * @param blockSize
         *        The size of the data blocks to write into the HDFS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockSize(Integer blockSize);

        /**
         * <p>
         * The number of DataNodes to replicate the data to when writing to the HDFS cluster.
         * </p>
         * 
         * @param replicationFactor
         *        The number of DataNodes to replicate the data to when writing to the HDFS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationFactor(Integer replicationFactor);

        /**
         * <p>
         * The URI of the HDFS cluster's Key Management Server (KMS).
         * </p>
         * 
         * @param kmsKeyProviderUri
         *        The URI of the HDFS cluster's Key Management Server (KMS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyProviderUri(String kmsKeyProviderUri);

        /**
         * <p>
         * The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer
         * protection settings configured on the Hadoop Distributed File System (HDFS) cluster.
         * </p>
         * 
         * @param qopConfiguration
         *        The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data
         *        transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qopConfiguration(QopConfiguration qopConfiguration);

        /**
         * <p>
         * The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer
         * protection settings configured on the Hadoop Distributed File System (HDFS) cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link QopConfiguration.Builder} avoiding the need to
         * create one manually via {@link QopConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link QopConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #qopConfiguration(QopConfiguration)}.
         * 
         * @param qopConfiguration
         *        a consumer that will call methods on {@link QopConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qopConfiguration(QopConfiguration)
         */
        default Builder qopConfiguration(Consumer<QopConfiguration.Builder> qopConfiguration) {
            return qopConfiguration(QopConfiguration.builder().applyMutation(qopConfiguration).build());
        }

        /**
         * <p>
         * The type of authentication used to determine the identity of the user.
         * </p>
         * 
         * @param authenticationType
         *        The type of authentication used to determine the identity of the user.
         * @see HdfsAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HdfsAuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The type of authentication used to determine the identity of the user.
         * </p>
         * 
         * @param authenticationType
         *        The type of authentication used to determine the identity of the user.
         * @see HdfsAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HdfsAuthenticationType
         */
        Builder authenticationType(HdfsAuthenticationType authenticationType);

        /**
         * <p>
         * The user name used to identify the client on the host operating system. This parameter is used if the
         * <code>AuthenticationType</code> is defined as <code>SIMPLE</code>.
         * </p>
         * 
         * @param simpleUser
         *        The user name used to identify the client on the host operating system. This parameter is used if the
         *        <code>AuthenticationType</code> is defined as <code>SIMPLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simpleUser(String simpleUser);

        /**
         * <p>
         * The Kerberos principal with access to the files and folders on the HDFS cluster. This parameter is used if
         * the <code>AuthenticationType</code> is defined as <code>KERBEROS</code>.
         * </p>
         * 
         * @param kerberosPrincipal
         *        The Kerberos principal with access to the files and folders on the HDFS cluster. This parameter is
         *        used if the <code>AuthenticationType</code> is defined as <code>KERBEROS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kerberosPrincipal(String kerberosPrincipal);

        /**
         * <p>
         * The ARNs of the agents that are used to connect to the HDFS cluster.
         * </p>
         * 
         * @param agentArns
         *        The ARNs of the agents that are used to connect to the HDFS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(Collection<String> agentArns);

        /**
         * <p>
         * The ARNs of the agents that are used to connect to the HDFS cluster.
         * </p>
         * 
         * @param agentArns
         *        The ARNs of the agents that are used to connect to the HDFS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(String... agentArns);

        /**
         * <p>
         * The time that the HDFS location was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the HDFS location was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String locationArn;

        private String locationUri;

        private List<HdfsNameNode> nameNodes = DefaultSdkAutoConstructList.getInstance();

        private Integer blockSize;

        private Integer replicationFactor;

        private String kmsKeyProviderUri;

        private QopConfiguration qopConfiguration;

        private String authenticationType;

        private String simpleUser;

        private String kerberosPrincipal;

        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationHdfsResponse model) {
            super(model);
            locationArn(model.locationArn);
            locationUri(model.locationUri);
            nameNodes(model.nameNodes);
            blockSize(model.blockSize);
            replicationFactor(model.replicationFactor);
            kmsKeyProviderUri(model.kmsKeyProviderUri);
            qopConfiguration(model.qopConfiguration);
            authenticationType(model.authenticationType);
            simpleUser(model.simpleUser);
            kerberosPrincipal(model.kerberosPrincipal);
            agentArns(model.agentArns);
            creationTime(model.creationTime);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        @Transient
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        @Transient
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final List<HdfsNameNode.Builder> getNameNodes() {
            List<HdfsNameNode.Builder> result = HdfsNameNodeListCopier.copyToBuilder(this.nameNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNameNodes(Collection<HdfsNameNode.BuilderImpl> nameNodes) {
            this.nameNodes = HdfsNameNodeListCopier.copyFromBuilder(nameNodes);
        }

        @Override
        @Transient
        public final Builder nameNodes(Collection<HdfsNameNode> nameNodes) {
            this.nameNodes = HdfsNameNodeListCopier.copy(nameNodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nameNodes(HdfsNameNode... nameNodes) {
            nameNodes(Arrays.asList(nameNodes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nameNodes(Consumer<HdfsNameNode.Builder>... nameNodes) {
            nameNodes(Stream.of(nameNodes).map(c -> HdfsNameNode.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getBlockSize() {
            return blockSize;
        }

        public final void setBlockSize(Integer blockSize) {
            this.blockSize = blockSize;
        }

        @Override
        @Transient
        public final Builder blockSize(Integer blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public final Integer getReplicationFactor() {
            return replicationFactor;
        }

        public final void setReplicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
        }

        @Override
        @Transient
        public final Builder replicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public final String getKmsKeyProviderUri() {
            return kmsKeyProviderUri;
        }

        public final void setKmsKeyProviderUri(String kmsKeyProviderUri) {
            this.kmsKeyProviderUri = kmsKeyProviderUri;
        }

        @Override
        @Transient
        public final Builder kmsKeyProviderUri(String kmsKeyProviderUri) {
            this.kmsKeyProviderUri = kmsKeyProviderUri;
            return this;
        }

        public final QopConfiguration.Builder getQopConfiguration() {
            return qopConfiguration != null ? qopConfiguration.toBuilder() : null;
        }

        public final void setQopConfiguration(QopConfiguration.BuilderImpl qopConfiguration) {
            this.qopConfiguration = qopConfiguration != null ? qopConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder qopConfiguration(QopConfiguration qopConfiguration) {
            this.qopConfiguration = qopConfiguration;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        @Transient
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        @Transient
        public final Builder authenticationType(HdfsAuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getSimpleUser() {
            return simpleUser;
        }

        public final void setSimpleUser(String simpleUser) {
            this.simpleUser = simpleUser;
        }

        @Override
        @Transient
        public final Builder simpleUser(String simpleUser) {
            this.simpleUser = simpleUser;
            return this;
        }

        public final String getKerberosPrincipal() {
            return kerberosPrincipal;
        }

        public final void setKerberosPrincipal(String kerberosPrincipal) {
            this.kerberosPrincipal = kerberosPrincipal;
        }

        @Override
        @Transient
        public final Builder kerberosPrincipal(String kerberosPrincipal) {
            this.kerberosPrincipal = kerberosPrincipal;
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        @Transient
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentArns(String... agentArns) {
            agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public DescribeLocationHdfsResponse build() {
            return new DescribeLocationHdfsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
