/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DiscoveryResourceFilter {
    SVM("SVM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DiscoveryResourceFilter> VALUE_MAP;
    private final String value;

    private DiscoveryResourceFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DiscoveryResourceFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DiscoveryResourceFilter> knownValues() {
        EnumSet<DiscoveryResourceFilter> knownValues = EnumSet.allOf(DiscoveryResourceFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DiscoveryResourceFilter.class, DiscoveryResourceFilter::toString);
    }
}

