/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListProjectProfilesRequest;
import software.amazon.awssdk.services.datazone.model.ListProjectProfilesResponse;
import software.amazon.awssdk.services.datazone.model.ProjectProfileSummary;

public class ListProjectProfilesIterable
implements SdkIterable<ListProjectProfilesResponse> {
    private final DataZoneClient client;
    private final ListProjectProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProjectProfilesIterable(DataZoneClient client, ListProjectProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProjectProfilesResponseFetcher();
    }

    public Iterator<ListProjectProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProjectProfileSummary> items() {
        Function<ListProjectProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProjectProfilesResponseFetcher
    implements SyncPageFetcher<ListProjectProfilesResponse> {
        private ListProjectProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListProjectProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProjectProfilesResponse nextPage(ListProjectProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListProjectProfilesIterable.this.client.listProjectProfiles(ListProjectProfilesIterable.this.firstRequest);
            }
            return ListProjectProfilesIterable.this.client.listProjectProfiles((ListProjectProfilesRequest)((Object)ListProjectProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

