/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueEnvironmentsResponse;
import software.amazon.awssdk.services.deadline.model.QueueEnvironmentSummary;

public class ListQueueEnvironmentsIterable
implements SdkIterable<ListQueueEnvironmentsResponse> {
    private final DeadlineClient client;
    private final ListQueueEnvironmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueueEnvironmentsIterable(DeadlineClient client, ListQueueEnvironmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListQueueEnvironmentsResponseFetcher();
    }

    public Iterator<ListQueueEnvironmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<QueueEnvironmentSummary> environments() {
        Function<ListQueueEnvironmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.environments() != null) {
                return response.environments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListQueueEnvironmentsResponseFetcher
    implements SyncPageFetcher<ListQueueEnvironmentsResponse> {
        private ListQueueEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueueEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQueueEnvironmentsResponse nextPage(ListQueueEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return ListQueueEnvironmentsIterable.this.client.listQueueEnvironments(ListQueueEnvironmentsIterable.this.firstRequest);
            }
            return ListQueueEnvironmentsIterable.this.client.listQueueEnvironments((ListQueueEnvironmentsRequest)((Object)ListQueueEnvironmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

