/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.QueueLimitAssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueueLimitAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueueLimitAssociationSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(QueueLimitAssociationSummary.getter(QueueLimitAssociationSummary::createdAt)).setter(QueueLimitAssociationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(QueueLimitAssociationSummary.getter(QueueLimitAssociationSummary::createdBy)).setter(QueueLimitAssociationSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(QueueLimitAssociationSummary.getter(QueueLimitAssociationSummary::updatedAt)).setter(QueueLimitAssociationSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(QueueLimitAssociationSummary.getter(QueueLimitAssociationSummary::updatedBy)).setter(QueueLimitAssociationSummary.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(QueueLimitAssociationSummary.getter(QueueLimitAssociationSummary::queueId)).setter(QueueLimitAssociationSummary.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()}).build();
    private static final SdkField<String> LIMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("limitId").getter(QueueLimitAssociationSummary.getter(QueueLimitAssociationSummary::limitId)).setter(QueueLimitAssociationSummary.setter(Builder::limitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limitId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(QueueLimitAssociationSummary.getter(QueueLimitAssociationSummary::statusAsString)).setter(QueueLimitAssociationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, QUEUE_ID_FIELD, LIMIT_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueueLimitAssociationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String createdBy;
    private final Instant updatedAt;
    private final String updatedBy;
    private final String queueId;
    private final String limitId;
    private final String status;

    private QueueLimitAssociationSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.queueId = builder.queueId;
        this.limitId = builder.limitId;
        this.status = builder.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String limitId() {
        return this.limitId;
    }

    public final QueueLimitAssociationStatus status() {
        return QueueLimitAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.limitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueLimitAssociationSummary)) {
            return false;
        }
        QueueLimitAssociationSummary other = (QueueLimitAssociationSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.limitId(), other.limitId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"QueueLimitAssociationSummary").add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).add("QueueId", (Object)this.queueId()).add("LimitId", (Object)this.limitId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "limitId": {
                return Optional.ofNullable(clazz.cast(this.limitId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("limitId", LIMIT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueueLimitAssociationSummary, T> g) {
        return obj -> g.apply((QueueLimitAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private Instant updatedAt;
        private String updatedBy;
        private String queueId;
        private String limitId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueLimitAssociationSummary model) {
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
            this.queueId(model.queueId);
            this.limitId(model.limitId);
            this.status(model.status);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getLimitId() {
            return this.limitId;
        }

        public final void setLimitId(String limitId) {
            this.limitId = limitId;
        }

        @Override
        public final Builder limitId(String limitId) {
            this.limitId = limitId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueLimitAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public QueueLimitAssociationSummary build() {
            return new QueueLimitAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueueLimitAssociationSummary> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);

        public Builder queueId(String var1);

        public Builder limitId(String var1);

        public Builder status(String var1);

        public Builder status(QueueLimitAssociationStatus var1);
    }
}

