/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UsageStatistic {
    SUM("SUM"),
    MIN("MIN"),
    MAX("MAX"),
    AVG("AVG"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UsageStatistic> VALUE_MAP;
    private final String value;

    private UsageStatistic(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UsageStatistic fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UsageStatistic> knownValues() {
        EnumSet<UsageStatistic> knownValues = EnumSet.allOf(UsageStatistic.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UsageStatistic.class, UsageStatistic::toString);
    }
}

