/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListQueueLimitAssociationsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueLimitAssociationsResponse;
import software.amazon.awssdk.services.deadline.model.QueueLimitAssociationSummary;

public class ListQueueLimitAssociationsIterable
implements SdkIterable<ListQueueLimitAssociationsResponse> {
    private final DeadlineClient client;
    private final ListQueueLimitAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueueLimitAssociationsIterable(DeadlineClient client, ListQueueLimitAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListQueueLimitAssociationsResponseFetcher();
    }

    public Iterator<ListQueueLimitAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<QueueLimitAssociationSummary> queueLimitAssociations() {
        Function<ListQueueLimitAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.queueLimitAssociations() != null) {
                return response.queueLimitAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListQueueLimitAssociationsResponseFetcher
    implements SyncPageFetcher<ListQueueLimitAssociationsResponse> {
        private ListQueueLimitAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueueLimitAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQueueLimitAssociationsResponse nextPage(ListQueueLimitAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListQueueLimitAssociationsIterable.this.client.listQueueLimitAssociations(ListQueueLimitAssociationsIterable.this.firstRequest);
            }
            return ListQueueLimitAssociationsIterable.this.client.listQueueLimitAssociations((ListQueueLimitAssociationsRequest)((Object)ListQueueLimitAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

