/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.MeteredProductSummary;
import software.amazon.awssdk.services.deadline.model.MeteredProductSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMeteredProductsResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, ListMeteredProductsResponse> {
    private static final SdkField<List<MeteredProductSummary>> METERED_PRODUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("meteredProducts").getter(ListMeteredProductsResponse.getter(ListMeteredProductsResponse::meteredProducts)).setter(ListMeteredProductsResponse.setter(Builder::meteredProducts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meteredProducts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MeteredProductSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMeteredProductsResponse.getter(ListMeteredProductsResponse::nextToken)).setter(ListMeteredProductsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METERED_PRODUCTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMeteredProductsResponse.memberNameToFieldInitializer();
    private final List<MeteredProductSummary> meteredProducts;
    private final String nextToken;

    private ListMeteredProductsResponse(BuilderImpl builder) {
        super(builder);
        this.meteredProducts = builder.meteredProducts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMeteredProducts() {
        return this.meteredProducts != null && !(this.meteredProducts instanceof SdkAutoConstructList);
    }

    public final List<MeteredProductSummary> meteredProducts() {
        return this.meteredProducts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMeteredProducts() ? this.meteredProducts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMeteredProductsResponse)) {
            return false;
        }
        ListMeteredProductsResponse other = (ListMeteredProductsResponse)((Object)obj);
        return this.hasMeteredProducts() == other.hasMeteredProducts() && Objects.equals(this.meteredProducts(), other.meteredProducts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMeteredProductsResponse").add("MeteredProducts", this.hasMeteredProducts() ? this.meteredProducts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "meteredProducts": {
                return Optional.ofNullable(clazz.cast(this.meteredProducts()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("meteredProducts", METERED_PRODUCTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMeteredProductsResponse, T> g) {
        return obj -> g.apply((ListMeteredProductsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private List<MeteredProductSummary> meteredProducts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMeteredProductsResponse model) {
            super(model);
            this.meteredProducts(model.meteredProducts);
            this.nextToken(model.nextToken);
        }

        public final List<MeteredProductSummary.Builder> getMeteredProducts() {
            List<MeteredProductSummary.Builder> result = MeteredProductSummaryListCopier.copyToBuilder(this.meteredProducts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMeteredProducts(Collection<MeteredProductSummary.BuilderImpl> meteredProducts) {
            this.meteredProducts = MeteredProductSummaryListCopier.copyFromBuilder(meteredProducts);
        }

        @Override
        public final Builder meteredProducts(Collection<MeteredProductSummary> meteredProducts) {
            this.meteredProducts = MeteredProductSummaryListCopier.copy(meteredProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder meteredProducts(MeteredProductSummary ... meteredProducts) {
            this.meteredProducts(Arrays.asList(meteredProducts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder meteredProducts(Consumer<MeteredProductSummary.Builder> ... meteredProducts) {
            this.meteredProducts(Stream.of(meteredProducts).map(c -> (MeteredProductSummary)((MeteredProductSummary.Builder)MeteredProductSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMeteredProductsResponse build() {
            return new ListMeteredProductsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMeteredProductsResponse> {
        public Builder meteredProducts(Collection<MeteredProductSummary> var1);

        public Builder meteredProducts(MeteredProductSummary ... var1);

        public Builder meteredProducts(Consumer<MeteredProductSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

