/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.BudgetActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BudgetActionToRemove
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BudgetActionToRemove> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(BudgetActionToRemove.getter(BudgetActionToRemove::typeAsString)).setter(BudgetActionToRemove.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Float> THRESHOLD_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("thresholdPercentage").getter(BudgetActionToRemove.getter(BudgetActionToRemove::thresholdPercentage)).setter(BudgetActionToRemove.setter(Builder::thresholdPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, THRESHOLD_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BudgetActionToRemove.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Float thresholdPercentage;

    private BudgetActionToRemove(BuilderImpl builder) {
        this.type = builder.type;
        this.thresholdPercentage = builder.thresholdPercentage;
    }

    public final BudgetActionType type() {
        return BudgetActionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Float thresholdPercentage() {
        return this.thresholdPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetActionToRemove)) {
            return false;
        }
        BudgetActionToRemove other = (BudgetActionToRemove)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.thresholdPercentage(), other.thresholdPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"BudgetActionToRemove").add("Type", (Object)this.typeAsString()).add("ThresholdPercentage", (Object)this.thresholdPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "thresholdPercentage": {
                return Optional.ofNullable(clazz.cast(this.thresholdPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("thresholdPercentage", THRESHOLD_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BudgetActionToRemove, T> g) {
        return obj -> g.apply((BudgetActionToRemove)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Float thresholdPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(BudgetActionToRemove model) {
            this.type(model.type);
            this.thresholdPercentage(model.thresholdPercentage);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BudgetActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Float getThresholdPercentage() {
            return this.thresholdPercentage;
        }

        public final void setThresholdPercentage(Float thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
        }

        @Override
        public final Builder thresholdPercentage(Float thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
            return this;
        }

        public BudgetActionToRemove build() {
            return new BudgetActionToRemove(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BudgetActionToRemove> {
        public Builder type(String var1);

        public Builder type(BudgetActionType var1);

        public Builder thresholdPercentage(Float var1);
    }
}

