/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionConfiguration> {
    private static final SdkField<Integer> JOB_TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("jobTimeoutMinutes").getter(ExecutionConfiguration.getter(ExecutionConfiguration::jobTimeoutMinutes)).setter(ExecutionConfiguration.setter(Builder::jobTimeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTimeoutMinutes").build()}).build();
    private static final SdkField<Boolean> ACCOUNTS_CLEANUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("accountsCleanup").getter(ExecutionConfiguration.getter(ExecutionConfiguration::accountsCleanup)).setter(ExecutionConfiguration.setter(Builder::accountsCleanup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountsCleanup").build()}).build();
    private static final SdkField<Boolean> APP_PACKAGES_CLEANUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("appPackagesCleanup").getter(ExecutionConfiguration.getter(ExecutionConfiguration::appPackagesCleanup)).setter(ExecutionConfiguration.setter(Builder::appPackagesCleanup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appPackagesCleanup").build()}).build();
    private static final SdkField<Boolean> VIDEO_CAPTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("videoCapture").getter(ExecutionConfiguration.getter(ExecutionConfiguration::videoCapture)).setter(ExecutionConfiguration.setter(Builder::videoCapture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoCapture").build()}).build();
    private static final SdkField<Boolean> SKIP_APP_RESIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("skipAppResign").getter(ExecutionConfiguration.getter(ExecutionConfiguration::skipAppResign)).setter(ExecutionConfiguration.setter(Builder::skipAppResign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipAppResign").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TIMEOUT_MINUTES_FIELD, ACCOUNTS_CLEANUP_FIELD, APP_PACKAGES_CLEANUP_FIELD, VIDEO_CAPTURE_FIELD, SKIP_APP_RESIGN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecutionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer jobTimeoutMinutes;
    private final Boolean accountsCleanup;
    private final Boolean appPackagesCleanup;
    private final Boolean videoCapture;
    private final Boolean skipAppResign;

    private ExecutionConfiguration(BuilderImpl builder) {
        this.jobTimeoutMinutes = builder.jobTimeoutMinutes;
        this.accountsCleanup = builder.accountsCleanup;
        this.appPackagesCleanup = builder.appPackagesCleanup;
        this.videoCapture = builder.videoCapture;
        this.skipAppResign = builder.skipAppResign;
    }

    public final Integer jobTimeoutMinutes() {
        return this.jobTimeoutMinutes;
    }

    public final Boolean accountsCleanup() {
        return this.accountsCleanup;
    }

    public final Boolean appPackagesCleanup() {
        return this.appPackagesCleanup;
    }

    public final Boolean videoCapture() {
        return this.videoCapture;
    }

    public final Boolean skipAppResign() {
        return this.skipAppResign;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountsCleanup());
        hashCode = 31 * hashCode + Objects.hashCode(this.appPackagesCleanup());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoCapture());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipAppResign());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionConfiguration)) {
            return false;
        }
        ExecutionConfiguration other = (ExecutionConfiguration)obj;
        return Objects.equals(this.jobTimeoutMinutes(), other.jobTimeoutMinutes()) && Objects.equals(this.accountsCleanup(), other.accountsCleanup()) && Objects.equals(this.appPackagesCleanup(), other.appPackagesCleanup()) && Objects.equals(this.videoCapture(), other.videoCapture()) && Objects.equals(this.skipAppResign(), other.skipAppResign());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionConfiguration").add("JobTimeoutMinutes", (Object)this.jobTimeoutMinutes()).add("AccountsCleanup", (Object)this.accountsCleanup()).add("AppPackagesCleanup", (Object)this.appPackagesCleanup()).add("VideoCapture", (Object)this.videoCapture()).add("SkipAppResign", (Object)this.skipAppResign()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobTimeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.jobTimeoutMinutes()));
            }
            case "accountsCleanup": {
                return Optional.ofNullable(clazz.cast(this.accountsCleanup()));
            }
            case "appPackagesCleanup": {
                return Optional.ofNullable(clazz.cast(this.appPackagesCleanup()));
            }
            case "videoCapture": {
                return Optional.ofNullable(clazz.cast(this.videoCapture()));
            }
            case "skipAppResign": {
                return Optional.ofNullable(clazz.cast(this.skipAppResign()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobTimeoutMinutes", JOB_TIMEOUT_MINUTES_FIELD);
        map.put("accountsCleanup", ACCOUNTS_CLEANUP_FIELD);
        map.put("appPackagesCleanup", APP_PACKAGES_CLEANUP_FIELD);
        map.put("videoCapture", VIDEO_CAPTURE_FIELD);
        map.put("skipAppResign", SKIP_APP_RESIGN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionConfiguration, T> g) {
        return obj -> g.apply((ExecutionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer jobTimeoutMinutes;
        private Boolean accountsCleanup;
        private Boolean appPackagesCleanup;
        private Boolean videoCapture;
        private Boolean skipAppResign;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionConfiguration model) {
            this.jobTimeoutMinutes(model.jobTimeoutMinutes);
            this.accountsCleanup(model.accountsCleanup);
            this.appPackagesCleanup(model.appPackagesCleanup);
            this.videoCapture(model.videoCapture);
            this.skipAppResign(model.skipAppResign);
        }

        public final Integer getJobTimeoutMinutes() {
            return this.jobTimeoutMinutes;
        }

        public final void setJobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
        }

        @Override
        public final Builder jobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
            return this;
        }

        public final Boolean getAccountsCleanup() {
            return this.accountsCleanup;
        }

        public final void setAccountsCleanup(Boolean accountsCleanup) {
            this.accountsCleanup = accountsCleanup;
        }

        @Override
        public final Builder accountsCleanup(Boolean accountsCleanup) {
            this.accountsCleanup = accountsCleanup;
            return this;
        }

        public final Boolean getAppPackagesCleanup() {
            return this.appPackagesCleanup;
        }

        public final void setAppPackagesCleanup(Boolean appPackagesCleanup) {
            this.appPackagesCleanup = appPackagesCleanup;
        }

        @Override
        public final Builder appPackagesCleanup(Boolean appPackagesCleanup) {
            this.appPackagesCleanup = appPackagesCleanup;
            return this;
        }

        public final Boolean getVideoCapture() {
            return this.videoCapture;
        }

        public final void setVideoCapture(Boolean videoCapture) {
            this.videoCapture = videoCapture;
        }

        @Override
        public final Builder videoCapture(Boolean videoCapture) {
            this.videoCapture = videoCapture;
            return this;
        }

        public final Boolean getSkipAppResign() {
            return this.skipAppResign;
        }

        public final void setSkipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
        }

        @Override
        public final Builder skipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
            return this;
        }

        public ExecutionConfiguration build() {
            return new ExecutionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionConfiguration> {
        public Builder jobTimeoutMinutes(Integer var1);

        public Builder accountsCleanup(Boolean var1);

        public Builder appPackagesCleanup(Boolean var1);

        public Builder videoCapture(Boolean var1);

        public Builder skipAppResign(Boolean var1);
    }
}

