/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFilter;
import software.amazon.awssdk.services.devicefarm.model.DeviceFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceSelectionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceSelectionConfiguration> {
    private static final SdkField<List<DeviceFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(DeviceSelectionConfiguration.getter(DeviceSelectionConfiguration::filters)).setter(DeviceSelectionConfiguration.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxDevices").getter(DeviceSelectionConfiguration.getter(DeviceSelectionConfiguration::maxDevices)).setter(DeviceSelectionConfiguration.setter(Builder::maxDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDevices").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, MAX_DEVICES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeviceSelectionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DeviceFilter> filters;
    private final Integer maxDevices;

    private DeviceSelectionConfiguration(BuilderImpl builder) {
        this.filters = builder.filters;
        this.maxDevices = builder.maxDevices;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<DeviceFilter> filters() {
        return this.filters;
    }

    public final Integer maxDevices() {
        return this.maxDevices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDevices());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSelectionConfiguration)) {
            return false;
        }
        DeviceSelectionConfiguration other = (DeviceSelectionConfiguration)obj;
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxDevices(), other.maxDevices());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceSelectionConfiguration").add("Filters", this.hasFilters() ? this.filters() : null).add("MaxDevices", (Object)this.maxDevices()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "maxDevices": {
                return Optional.ofNullable(clazz.cast(this.maxDevices()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filters", FILTERS_FIELD);
        map.put("maxDevices", MAX_DEVICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceSelectionConfiguration, T> g) {
        return obj -> g.apply((DeviceSelectionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DeviceFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxDevices;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSelectionConfiguration model) {
            this.filters(model.filters);
            this.maxDevices(model.maxDevices);
        }

        public final List<DeviceFilter.Builder> getFilters() {
            List<DeviceFilter.Builder> result = DeviceFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<DeviceFilter.BuilderImpl> filters) {
            this.filters = DeviceFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<DeviceFilter> filters) {
            this.filters = DeviceFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DeviceFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DeviceFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (DeviceFilter)((DeviceFilter.Builder)DeviceFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxDevices() {
            return this.maxDevices;
        }

        public final void setMaxDevices(Integer maxDevices) {
            this.maxDevices = maxDevices;
        }

        @Override
        public final Builder maxDevices(Integer maxDevices) {
            this.maxDevices = maxDevices;
            return this;
        }

        public DeviceSelectionConfiguration build() {
            return new DeviceSelectionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceSelectionConfiguration> {
        public Builder filters(Collection<DeviceFilter> var1);

        public Builder filters(DeviceFilter ... var1);

        public Builder filters(Consumer<DeviceFilter.Builder> ... var1);

        public Builder maxDevices(Integer var1);
    }
}

