/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.MonetaryAmount;
import software.amazon.awssdk.services.devicefarm.model.RecurringChargeFrequency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecurringCharge
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecurringCharge> {
    private static final SdkField<MonetaryAmount> COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cost").getter(RecurringCharge.getter(RecurringCharge::cost)).setter(RecurringCharge.setter(Builder::cost)).constructor(MonetaryAmount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()}).build();
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frequency").getter(RecurringCharge.getter(RecurringCharge::frequencyAsString)).setter(RecurringCharge.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_FIELD, FREQUENCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecurringCharge.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final MonetaryAmount cost;
    private final String frequency;

    private RecurringCharge(BuilderImpl builder) {
        this.cost = builder.cost;
        this.frequency = builder.frequency;
    }

    public final MonetaryAmount cost() {
        return this.cost;
    }

    public final RecurringChargeFrequency frequency() {
        return RecurringChargeFrequency.fromValue(this.frequency);
    }

    public final String frequencyAsString() {
        return this.frequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cost());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringCharge)) {
            return false;
        }
        RecurringCharge other = (RecurringCharge)obj;
        return Objects.equals(this.cost(), other.cost()) && Objects.equals(this.frequencyAsString(), other.frequencyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RecurringCharge").add("Cost", (Object)this.cost()).add("Frequency", (Object)this.frequencyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cost": {
                return Optional.ofNullable(clazz.cast(this.cost()));
            }
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cost", COST_FIELD);
        map.put("frequency", FREQUENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecurringCharge, T> g) {
        return obj -> g.apply((RecurringCharge)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MonetaryAmount cost;
        private String frequency;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurringCharge model) {
            this.cost(model.cost);
            this.frequency(model.frequency);
        }

        public final MonetaryAmount.Builder getCost() {
            return this.cost != null ? this.cost.toBuilder() : null;
        }

        public final void setCost(MonetaryAmount.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        @Override
        public final Builder cost(MonetaryAmount cost) {
            this.cost = cost;
            return this;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(RecurringChargeFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public RecurringCharge build() {
            return new RecurringCharge(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecurringCharge> {
        public Builder cost(MonetaryAmount var1);

        default public Builder cost(Consumer<MonetaryAmount.Builder> cost) {
            return this.cost((MonetaryAmount)((MonetaryAmount.Builder)MonetaryAmount.builder().applyMutation(cost)).build());
        }

        public Builder frequency(String var1);

        public Builder frequency(RecurringChargeFrequency var1);
    }
}

