/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.TestGridSessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestGridSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestGridSession> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(TestGridSession.getter(TestGridSession::arn)).setter(TestGridSession.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TestGridSession.getter(TestGridSession::statusAsString)).setter(TestGridSession.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(TestGridSession.getter(TestGridSession::created)).setter(TestGridSession.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<Instant> ENDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ended").getter(TestGridSession.getter(TestGridSession::ended)).setter(TestGridSession.setter(Builder::ended)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ended").build()}).build();
    private static final SdkField<Double> BILLING_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("billingMinutes").getter(TestGridSession.getter(TestGridSession::billingMinutes)).setter(TestGridSession.setter(Builder::billingMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingMinutes").build()}).build();
    private static final SdkField<String> SELENIUM_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("seleniumProperties").getter(TestGridSession.getter(TestGridSession::seleniumProperties)).setter(TestGridSession.setter(Builder::seleniumProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seleniumProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD, CREATED_FIELD, ENDED_FIELD, BILLING_MINUTES_FIELD, SELENIUM_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestGridSession.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String status;
    private final Instant created;
    private final Instant ended;
    private final Double billingMinutes;
    private final String seleniumProperties;

    private TestGridSession(BuilderImpl builder) {
        this.arn = builder.arn;
        this.status = builder.status;
        this.created = builder.created;
        this.ended = builder.ended;
        this.billingMinutes = builder.billingMinutes;
        this.seleniumProperties = builder.seleniumProperties;
    }

    public final String arn() {
        return this.arn;
    }

    public final TestGridSessionStatus status() {
        return TestGridSessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant created() {
        return this.created;
    }

    public final Instant ended() {
        return this.ended;
    }

    public final Double billingMinutes() {
        return this.billingMinutes;
    }

    public final String seleniumProperties() {
        return this.seleniumProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.ended());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.seleniumProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestGridSession)) {
            return false;
        }
        TestGridSession other = (TestGridSession)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.ended(), other.ended()) && Objects.equals(this.billingMinutes(), other.billingMinutes()) && Objects.equals(this.seleniumProperties(), other.seleniumProperties());
    }

    public final String toString() {
        return ToString.builder((String)"TestGridSession").add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("Created", (Object)this.created()).add("Ended", (Object)this.ended()).add("BillingMinutes", (Object)this.billingMinutes()).add("SeleniumProperties", (Object)this.seleniumProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "ended": {
                return Optional.ofNullable(clazz.cast(this.ended()));
            }
            case "billingMinutes": {
                return Optional.ofNullable(clazz.cast(this.billingMinutes()));
            }
            case "seleniumProperties": {
                return Optional.ofNullable(clazz.cast(this.seleniumProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("created", CREATED_FIELD);
        map.put("ended", ENDED_FIELD);
        map.put("billingMinutes", BILLING_MINUTES_FIELD);
        map.put("seleniumProperties", SELENIUM_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestGridSession, T> g) {
        return obj -> g.apply((TestGridSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String status;
        private Instant created;
        private Instant ended;
        private Double billingMinutes;
        private String seleniumProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(TestGridSession model) {
            this.arn(model.arn);
            this.status(model.status);
            this.created(model.created);
            this.ended(model.ended);
            this.billingMinutes(model.billingMinutes);
            this.seleniumProperties(model.seleniumProperties);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestGridSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getEnded() {
            return this.ended;
        }

        public final void setEnded(Instant ended) {
            this.ended = ended;
        }

        @Override
        public final Builder ended(Instant ended) {
            this.ended = ended;
            return this;
        }

        public final Double getBillingMinutes() {
            return this.billingMinutes;
        }

        public final void setBillingMinutes(Double billingMinutes) {
            this.billingMinutes = billingMinutes;
        }

        @Override
        public final Builder billingMinutes(Double billingMinutes) {
            this.billingMinutes = billingMinutes;
            return this;
        }

        public final String getSeleniumProperties() {
            return this.seleniumProperties;
        }

        public final void setSeleniumProperties(String seleniumProperties) {
            this.seleniumProperties = seleniumProperties;
        }

        @Override
        public final Builder seleniumProperties(String seleniumProperties) {
            this.seleniumProperties = seleniumProperties;
            return this;
        }

        public TestGridSession build() {
            return new TestGridSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestGridSession> {
        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(TestGridSessionStatus var1);

        public Builder created(Instant var1);

        public Builder ended(Instant var1);

        public Builder billingMinutes(Double var1);

        public Builder seleniumProperties(String var1);
    }
}

