/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruRequest;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollectionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeResourceCollectionHealthRequest
extends DevOpsGuruRequest
implements ToCopyableBuilder<Builder, DescribeResourceCollectionHealthRequest> {
    private static final SdkField<String> RESOURCE_COLLECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceCollectionType").getter(DescribeResourceCollectionHealthRequest.getter(DescribeResourceCollectionHealthRequest::resourceCollectionTypeAsString)).setter(DescribeResourceCollectionHealthRequest.setter(Builder::resourceCollectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceCollectionType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeResourceCollectionHealthRequest.getter(DescribeResourceCollectionHealthRequest::nextToken)).setter(DescribeResourceCollectionHealthRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_COLLECTION_TYPE_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeResourceCollectionHealthRequest.memberNameToFieldInitializer();
    private final String resourceCollectionType;
    private final String nextToken;

    private DescribeResourceCollectionHealthRequest(BuilderImpl builder) {
        super(builder);
        this.resourceCollectionType = builder.resourceCollectionType;
        this.nextToken = builder.nextToken;
    }

    public final ResourceCollectionType resourceCollectionType() {
        return ResourceCollectionType.fromValue(this.resourceCollectionType);
    }

    public final String resourceCollectionTypeAsString() {
        return this.resourceCollectionType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceCollectionHealthRequest)) {
            return false;
        }
        DescribeResourceCollectionHealthRequest other = (DescribeResourceCollectionHealthRequest)((Object)obj);
        return Objects.equals(this.resourceCollectionTypeAsString(), other.resourceCollectionTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeResourceCollectionHealthRequest").add("ResourceCollectionType", (Object)this.resourceCollectionTypeAsString()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceCollectionType": {
                return Optional.ofNullable(clazz.cast(this.resourceCollectionTypeAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceCollectionType", RESOURCE_COLLECTION_TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceCollectionHealthRequest, T> g) {
        return obj -> g.apply((DescribeResourceCollectionHealthRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruRequest.BuilderImpl
    implements Builder {
        private String resourceCollectionType;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceCollectionHealthRequest model) {
            super(model);
            this.resourceCollectionType(model.resourceCollectionType);
            this.nextToken(model.nextToken);
        }

        public final String getResourceCollectionType() {
            return this.resourceCollectionType;
        }

        public final void setResourceCollectionType(String resourceCollectionType) {
            this.resourceCollectionType = resourceCollectionType;
        }

        @Override
        public final Builder resourceCollectionType(String resourceCollectionType) {
            this.resourceCollectionType = resourceCollectionType;
            return this;
        }

        @Override
        public final Builder resourceCollectionType(ResourceCollectionType resourceCollectionType) {
            this.resourceCollectionType(resourceCollectionType == null ? null : resourceCollectionType.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeResourceCollectionHealthRequest build() {
            return new DescribeResourceCollectionHealthRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DevOpsGuruRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeResourceCollectionHealthRequest> {
        public Builder resourceCollectionType(String var1);

        public Builder resourceCollectionType(ResourceCollectionType var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

