/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.internal.UserAgentUtils;
import software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest;
import software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse;
import software.amazon.awssdk.services.devopsguru.model.ProactiveAnomalySummary;
import software.amazon.awssdk.services.devopsguru.model.ReactiveAnomalySummary;

public class ListAnomaliesForInsightPublisher
implements SdkPublisher<ListAnomaliesForInsightResponse> {
    private final DevOpsGuruAsyncClient client;
    private final ListAnomaliesForInsightRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnomaliesForInsightPublisher(DevOpsGuruAsyncClient client, ListAnomaliesForInsightRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnomaliesForInsightPublisher(DevOpsGuruAsyncClient client, ListAnomaliesForInsightRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnomaliesForInsightResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnomaliesForInsightResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReactiveAnomalySummary> reactiveAnomalies() {
        Function<ListAnomaliesForInsightResponse, Iterator> getIterator = response -> {
            if (response != null && response.reactiveAnomalies() != null) {
                return response.reactiveAnomalies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAnomaliesForInsightResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<ProactiveAnomalySummary> proactiveAnomalies() {
        Function<ListAnomaliesForInsightResponse, Iterator> getIterator = response -> {
            if (response != null && response.proactiveAnomalies() != null) {
                return response.proactiveAnomalies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAnomaliesForInsightResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAnomaliesForInsightResponseFetcher
    implements AsyncPageFetcher<ListAnomaliesForInsightResponse> {
        private ListAnomaliesForInsightResponseFetcher() {
        }

        public boolean hasNextPage(ListAnomaliesForInsightResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnomaliesForInsightResponse> nextPage(ListAnomaliesForInsightResponse previousPage) {
            if (previousPage == null) {
                return ListAnomaliesForInsightPublisher.this.client.listAnomaliesForInsight(ListAnomaliesForInsightPublisher.this.firstRequest);
            }
            return ListAnomaliesForInsightPublisher.this.client.listAnomaliesForInsight((ListAnomaliesForInsightRequest)((Object)ListAnomaliesForInsightPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

