/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateMacSecKeyRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, AssociateMacSecKeyRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(AssociateMacSecKeyRequest.getter(AssociateMacSecKeyRequest::connectionId)).setter(AssociateMacSecKeyRequest.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretARN").getter(AssociateMacSecKeyRequest.getter(AssociateMacSecKeyRequest::secretARN)).setter(AssociateMacSecKeyRequest.setter(Builder::secretARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretARN").build()}).build();
    private static final SdkField<String> CKN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ckn").getter(AssociateMacSecKeyRequest.getter(AssociateMacSecKeyRequest::ckn)).setter(AssociateMacSecKeyRequest.setter(Builder::ckn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ckn").build()}).build();
    private static final SdkField<String> CAK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cak").getter(AssociateMacSecKeyRequest.getter(AssociateMacSecKeyRequest::cak)).setter(AssociateMacSecKeyRequest.setter(Builder::cak)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cak").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, SECRET_ARN_FIELD, CKN_FIELD, CAK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateMacSecKeyRequest.memberNameToFieldInitializer();
    private final String connectionId;
    private final String secretARN;
    private final String ckn;
    private final String cak;

    private AssociateMacSecKeyRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.secretARN = builder.secretARN;
        this.ckn = builder.ckn;
        this.cak = builder.cak;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final String secretARN() {
        return this.secretARN;
    }

    public final String ckn() {
        return this.ckn;
    }

    public final String cak() {
        return this.cak;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.ckn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cak());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateMacSecKeyRequest)) {
            return false;
        }
        AssociateMacSecKeyRequest other = (AssociateMacSecKeyRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.secretARN(), other.secretARN()) && Objects.equals(this.ckn(), other.ckn()) && Objects.equals(this.cak(), other.cak());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateMacSecKeyRequest").add("ConnectionId", (Object)this.connectionId()).add("SecretARN", (Object)this.secretARN()).add("Ckn", (Object)this.ckn()).add("Cak", (Object)this.cak()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "secretARN": {
                return Optional.ofNullable(clazz.cast(this.secretARN()));
            }
            case "ckn": {
                return Optional.ofNullable(clazz.cast(this.ckn()));
            }
            case "cak": {
                return Optional.ofNullable(clazz.cast(this.cak()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("connectionId", CONNECTION_ID_FIELD);
        map.put("secretARN", SECRET_ARN_FIELD);
        map.put("ckn", CKN_FIELD);
        map.put("cak", CAK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateMacSecKeyRequest, T> g) {
        return obj -> g.apply((AssociateMacSecKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String secretARN;
        private String ckn;
        private String cak;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateMacSecKeyRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.secretARN(model.secretARN);
            this.ckn(model.ckn);
            this.cak(model.cak);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getSecretARN() {
            return this.secretARN;
        }

        public final void setSecretARN(String secretARN) {
            this.secretARN = secretARN;
        }

        @Override
        public final Builder secretARN(String secretARN) {
            this.secretARN = secretARN;
            return this;
        }

        public final String getCkn() {
            return this.ckn;
        }

        public final void setCkn(String ckn) {
            this.ckn = ckn;
        }

        @Override
        public final Builder ckn(String ckn) {
            this.ckn = ckn;
            return this;
        }

        public final String getCak() {
            return this.cak;
        }

        public final void setCak(String cak) {
            this.cak = cak;
        }

        @Override
        public final Builder cak(String cak) {
            this.cak = cak;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateMacSecKeyRequest build() {
            return new AssociateMacSecKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateMacSecKeyRequest> {
        public Builder connectionId(String var1);

        public Builder secretARN(String var1);

        public Builder ckn(String var1);

        public Builder cak(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

