/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.services.directory.model.EventTopic;
import software.amazon.awssdk.services.directory.model.EventTopicsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventTopicsResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeEventTopicsResponse> {
    private static final SdkField<List<EventTopic>> EVENT_TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventTopics").getter(DescribeEventTopicsResponse.getter(DescribeEventTopicsResponse::eventTopics)).setter(DescribeEventTopicsResponse.setter(Builder::eventTopics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTopics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventTopic::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TOPICS_FIELD));
    private final List<EventTopic> eventTopics;

    private DescribeEventTopicsResponse(BuilderImpl builder) {
        super(builder);
        this.eventTopics = builder.eventTopics;
    }

    public final boolean hasEventTopics() {
        return this.eventTopics != null && !(this.eventTopics instanceof SdkAutoConstructList);
    }

    public final List<EventTopic> eventTopics() {
        return this.eventTopics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTopics() ? this.eventTopics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventTopicsResponse)) {
            return false;
        }
        DescribeEventTopicsResponse other = (DescribeEventTopicsResponse)((Object)obj);
        return this.hasEventTopics() == other.hasEventTopics() && Objects.equals(this.eventTopics(), other.eventTopics());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEventTopicsResponse").add("EventTopics", this.hasEventTopics() ? this.eventTopics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventTopics": {
                return Optional.ofNullable(clazz.cast(this.eventTopics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventTopicsResponse, T> g) {
        return obj -> g.apply((DescribeEventTopicsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<EventTopic> eventTopics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventTopicsResponse model) {
            super(model);
            this.eventTopics(model.eventTopics);
        }

        public final List<EventTopic.Builder> getEventTopics() {
            List<EventTopic.Builder> result = EventTopicsCopier.copyToBuilder(this.eventTopics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTopics(Collection<EventTopic.BuilderImpl> eventTopics) {
            this.eventTopics = EventTopicsCopier.copyFromBuilder(eventTopics);
        }

        @Override
        @Transient
        public final Builder eventTopics(Collection<EventTopic> eventTopics) {
            this.eventTopics = EventTopicsCopier.copy(eventTopics);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventTopics(EventTopic ... eventTopics) {
            this.eventTopics(Arrays.asList(eventTopics));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventTopics(Consumer<EventTopic.Builder> ... eventTopics) {
            this.eventTopics(Stream.of(eventTopics).map(c -> (EventTopic)((EventTopic.Builder)EventTopic.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEventTopicsResponse build() {
            return new DescribeEventTopicsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventTopicsResponse> {
        public Builder eventTopics(Collection<EventTopic> var1);

        public Builder eventTopics(EventTopic ... var1);

        public Builder eventTopics(Consumer<EventTopic.Builder> ... var1);
    }
}

