/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.services.directory.model.RegionDescription;
import software.amazon.awssdk.services.directory.model.RegionsDescriptionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegionsResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeRegionsResponse> {
    private static final SdkField<List<RegionDescription>> REGIONS_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionsDescription").getter(DescribeRegionsResponse.getter(DescribeRegionsResponse::regionsDescription)).setter(DescribeRegionsResponse.setter(Builder::regionsDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionsDescription").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRegionsResponse.getter(DescribeRegionsResponse::nextToken)).setter(DescribeRegionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGIONS_DESCRIPTION_FIELD, NEXT_TOKEN_FIELD));
    private final List<RegionDescription> regionsDescription;
    private final String nextToken;

    private DescribeRegionsResponse(BuilderImpl builder) {
        super(builder);
        this.regionsDescription = builder.regionsDescription;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRegionsDescription() {
        return this.regionsDescription != null && !(this.regionsDescription instanceof SdkAutoConstructList);
    }

    public final List<RegionDescription> regionsDescription() {
        return this.regionsDescription;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionsDescription() ? this.regionsDescription() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegionsResponse)) {
            return false;
        }
        DescribeRegionsResponse other = (DescribeRegionsResponse)((Object)obj);
        return this.hasRegionsDescription() == other.hasRegionsDescription() && Objects.equals(this.regionsDescription(), other.regionsDescription()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRegionsResponse").add("RegionsDescription", this.hasRegionsDescription() ? this.regionsDescription() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionsDescription": {
                return Optional.ofNullable(clazz.cast(this.regionsDescription()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegionsResponse, T> g) {
        return obj -> g.apply((DescribeRegionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<RegionDescription> regionsDescription = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegionsResponse model) {
            super(model);
            this.regionsDescription(model.regionsDescription);
            this.nextToken(model.nextToken);
        }

        public final List<RegionDescription.Builder> getRegionsDescription() {
            List<RegionDescription.Builder> result = RegionsDescriptionCopier.copyToBuilder(this.regionsDescription);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegionsDescription(Collection<RegionDescription.BuilderImpl> regionsDescription) {
            this.regionsDescription = RegionsDescriptionCopier.copyFromBuilder(regionsDescription);
        }

        @Override
        @Transient
        public final Builder regionsDescription(Collection<RegionDescription> regionsDescription) {
            this.regionsDescription = RegionsDescriptionCopier.copy(regionsDescription);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder regionsDescription(RegionDescription ... regionsDescription) {
            this.regionsDescription(Arrays.asList(regionsDescription));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder regionsDescription(Consumer<RegionDescription.Builder> ... regionsDescription) {
            this.regionsDescription(Stream.of(regionsDescription).map(c -> (RegionDescription)((RegionDescription.Builder)RegionDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRegionsResponse build() {
            return new DescribeRegionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegionsResponse> {
        public Builder regionsDescription(Collection<RegionDescription> var1);

        public Builder regionsDescription(RegionDescription ... var1);

        public Builder regionsDescription(Consumer<RegionDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

