/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryConnectSettingsDescription;
import software.amazon.awssdk.services.directory.model.DirectoryEdition;
import software.amazon.awssdk.services.directory.model.DirectorySize;
import software.amazon.awssdk.services.directory.model.DirectoryStage;
import software.amazon.awssdk.services.directory.model.DirectoryType;
import software.amazon.awssdk.services.directory.model.DirectoryVpcSettingsDescription;
import software.amazon.awssdk.services.directory.model.DnsIpAddrsCopier;
import software.amazon.awssdk.services.directory.model.OSVersion;
import software.amazon.awssdk.services.directory.model.OwnerDirectoryDescription;
import software.amazon.awssdk.services.directory.model.RadiusSettings;
import software.amazon.awssdk.services.directory.model.RadiusStatus;
import software.amazon.awssdk.services.directory.model.RegionsInfo;
import software.amazon.awssdk.services.directory.model.ShareMethod;
import software.amazon.awssdk.services.directory.model.ShareStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectoryDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectoryDescription> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(DirectoryDescription.getter(DirectoryDescription::directoryId)).setter(DirectoryDescription.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DirectoryDescription.getter(DirectoryDescription::name)).setter(DirectoryDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SHORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShortName").getter(DirectoryDescription.getter(DirectoryDescription::shortName)).setter(DirectoryDescription.setter(Builder::shortName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortName").build()}).build();
    private static final SdkField<String> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Size").getter(DirectoryDescription.getter(DirectoryDescription::sizeAsString)).setter(DirectoryDescription.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<String> EDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Edition").getter(DirectoryDescription.getter(DirectoryDescription::editionAsString)).setter(DirectoryDescription.setter(Builder::edition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(DirectoryDescription.getter(DirectoryDescription::alias)).setter(DirectoryDescription.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<String> ACCESS_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessUrl").getter(DirectoryDescription.getter(DirectoryDescription::accessUrl)).setter(DirectoryDescription.setter(Builder::accessUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessUrl").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DirectoryDescription.getter(DirectoryDescription::description)).setter(DirectoryDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> DNS_IP_ADDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsIpAddrs").getter(DirectoryDescription.getter(DirectoryDescription::dnsIpAddrs)).setter(DirectoryDescription.setter(Builder::dnsIpAddrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIpAddrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(DirectoryDescription.getter(DirectoryDescription::stageAsString)).setter(DirectoryDescription.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()}).build();
    private static final SdkField<String> SHARE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareStatus").getter(DirectoryDescription.getter(DirectoryDescription::shareStatusAsString)).setter(DirectoryDescription.setter(Builder::shareStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareStatus").build()}).build();
    private static final SdkField<String> SHARE_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareMethod").getter(DirectoryDescription.getter(DirectoryDescription::shareMethodAsString)).setter(DirectoryDescription.setter(Builder::shareMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareMethod").build()}).build();
    private static final SdkField<String> SHARE_NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareNotes").getter(DirectoryDescription.getter(DirectoryDescription::shareNotes)).setter(DirectoryDescription.setter(Builder::shareNotes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareNotes").build()}).build();
    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LaunchTime").getter(DirectoryDescription.getter(DirectoryDescription::launchTime)).setter(DirectoryDescription.setter(Builder::launchTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").build()}).build();
    private static final SdkField<Instant> STAGE_LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StageLastUpdatedDateTime").getter(DirectoryDescription.getter(DirectoryDescription::stageLastUpdatedDateTime)).setter(DirectoryDescription.setter(Builder::stageLastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageLastUpdatedDateTime").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DirectoryDescription.getter(DirectoryDescription::typeAsString)).setter(DirectoryDescription.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<DirectoryVpcSettingsDescription> VPC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcSettings").getter(DirectoryDescription.getter(DirectoryDescription::vpcSettings)).setter(DirectoryDescription.setter(Builder::vpcSettings)).constructor(DirectoryVpcSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSettings").build()}).build();
    private static final SdkField<DirectoryConnectSettingsDescription> CONNECT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectSettings").getter(DirectoryDescription.getter(DirectoryDescription::connectSettings)).setter(DirectoryDescription.setter(Builder::connectSettings)).constructor(DirectoryConnectSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectSettings").build()}).build();
    private static final SdkField<RadiusSettings> RADIUS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RadiusSettings").getter(DirectoryDescription.getter(DirectoryDescription::radiusSettings)).setter(DirectoryDescription.setter(Builder::radiusSettings)).constructor(RadiusSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadiusSettings").build()}).build();
    private static final SdkField<String> RADIUS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RadiusStatus").getter(DirectoryDescription.getter(DirectoryDescription::radiusStatusAsString)).setter(DirectoryDescription.setter(Builder::radiusStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadiusStatus").build()}).build();
    private static final SdkField<String> STAGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageReason").getter(DirectoryDescription.getter(DirectoryDescription::stageReason)).setter(DirectoryDescription.setter(Builder::stageReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageReason").build()}).build();
    private static final SdkField<Boolean> SSO_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SsoEnabled").getter(DirectoryDescription.getter(DirectoryDescription::ssoEnabled)).setter(DirectoryDescription.setter(Builder::ssoEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SsoEnabled").build()}).build();
    private static final SdkField<Integer> DESIRED_NUMBER_OF_DOMAIN_CONTROLLERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DesiredNumberOfDomainControllers").getter(DirectoryDescription.getter(DirectoryDescription::desiredNumberOfDomainControllers)).setter(DirectoryDescription.setter(Builder::desiredNumberOfDomainControllers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredNumberOfDomainControllers").build()}).build();
    private static final SdkField<OwnerDirectoryDescription> OWNER_DIRECTORY_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OwnerDirectoryDescription").getter(DirectoryDescription.getter(DirectoryDescription::ownerDirectoryDescription)).setter(DirectoryDescription.setter(Builder::ownerDirectoryDescription)).constructor(OwnerDirectoryDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerDirectoryDescription").build()}).build();
    private static final SdkField<RegionsInfo> REGIONS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RegionsInfo").getter(DirectoryDescription.getter(DirectoryDescription::regionsInfo)).setter(DirectoryDescription.setter(Builder::regionsInfo)).constructor(RegionsInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionsInfo").build()}).build();
    private static final SdkField<String> OS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OsVersion").getter(DirectoryDescription.getter(DirectoryDescription::osVersionAsString)).setter(DirectoryDescription.setter(Builder::osVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OsVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, NAME_FIELD, SHORT_NAME_FIELD, SIZE_FIELD, EDITION_FIELD, ALIAS_FIELD, ACCESS_URL_FIELD, DESCRIPTION_FIELD, DNS_IP_ADDRS_FIELD, STAGE_FIELD, SHARE_STATUS_FIELD, SHARE_METHOD_FIELD, SHARE_NOTES_FIELD, LAUNCH_TIME_FIELD, STAGE_LAST_UPDATED_DATE_TIME_FIELD, TYPE_FIELD, VPC_SETTINGS_FIELD, CONNECT_SETTINGS_FIELD, RADIUS_SETTINGS_FIELD, RADIUS_STATUS_FIELD, STAGE_REASON_FIELD, SSO_ENABLED_FIELD, DESIRED_NUMBER_OF_DOMAIN_CONTROLLERS_FIELD, OWNER_DIRECTORY_DESCRIPTION_FIELD, REGIONS_INFO_FIELD, OS_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DirectoryDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String directoryId;
    private final String name;
    private final String shortName;
    private final String size;
    private final String edition;
    private final String alias;
    private final String accessUrl;
    private final String description;
    private final List<String> dnsIpAddrs;
    private final String stage;
    private final String shareStatus;
    private final String shareMethod;
    private final String shareNotes;
    private final Instant launchTime;
    private final Instant stageLastUpdatedDateTime;
    private final String type;
    private final DirectoryVpcSettingsDescription vpcSettings;
    private final DirectoryConnectSettingsDescription connectSettings;
    private final RadiusSettings radiusSettings;
    private final String radiusStatus;
    private final String stageReason;
    private final Boolean ssoEnabled;
    private final Integer desiredNumberOfDomainControllers;
    private final OwnerDirectoryDescription ownerDirectoryDescription;
    private final RegionsInfo regionsInfo;
    private final String osVersion;

    private DirectoryDescription(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.name = builder.name;
        this.shortName = builder.shortName;
        this.size = builder.size;
        this.edition = builder.edition;
        this.alias = builder.alias;
        this.accessUrl = builder.accessUrl;
        this.description = builder.description;
        this.dnsIpAddrs = builder.dnsIpAddrs;
        this.stage = builder.stage;
        this.shareStatus = builder.shareStatus;
        this.shareMethod = builder.shareMethod;
        this.shareNotes = builder.shareNotes;
        this.launchTime = builder.launchTime;
        this.stageLastUpdatedDateTime = builder.stageLastUpdatedDateTime;
        this.type = builder.type;
        this.vpcSettings = builder.vpcSettings;
        this.connectSettings = builder.connectSettings;
        this.radiusSettings = builder.radiusSettings;
        this.radiusStatus = builder.radiusStatus;
        this.stageReason = builder.stageReason;
        this.ssoEnabled = builder.ssoEnabled;
        this.desiredNumberOfDomainControllers = builder.desiredNumberOfDomainControllers;
        this.ownerDirectoryDescription = builder.ownerDirectoryDescription;
        this.regionsInfo = builder.regionsInfo;
        this.osVersion = builder.osVersion;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String name() {
        return this.name;
    }

    public final String shortName() {
        return this.shortName;
    }

    public final DirectorySize size() {
        return DirectorySize.fromValue(this.size);
    }

    public final String sizeAsString() {
        return this.size;
    }

    public final DirectoryEdition edition() {
        return DirectoryEdition.fromValue(this.edition);
    }

    public final String editionAsString() {
        return this.edition;
    }

    public final String alias() {
        return this.alias;
    }

    public final String accessUrl() {
        return this.accessUrl;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasDnsIpAddrs() {
        return this.dnsIpAddrs != null && !(this.dnsIpAddrs instanceof SdkAutoConstructList);
    }

    public final List<String> dnsIpAddrs() {
        return this.dnsIpAddrs;
    }

    public final DirectoryStage stage() {
        return DirectoryStage.fromValue(this.stage);
    }

    public final String stageAsString() {
        return this.stage;
    }

    public final ShareStatus shareStatus() {
        return ShareStatus.fromValue(this.shareStatus);
    }

    public final String shareStatusAsString() {
        return this.shareStatus;
    }

    public final ShareMethod shareMethod() {
        return ShareMethod.fromValue(this.shareMethod);
    }

    public final String shareMethodAsString() {
        return this.shareMethod;
    }

    public final String shareNotes() {
        return this.shareNotes;
    }

    public final Instant launchTime() {
        return this.launchTime;
    }

    public final Instant stageLastUpdatedDateTime() {
        return this.stageLastUpdatedDateTime;
    }

    public final DirectoryType type() {
        return DirectoryType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final DirectoryVpcSettingsDescription vpcSettings() {
        return this.vpcSettings;
    }

    public final DirectoryConnectSettingsDescription connectSettings() {
        return this.connectSettings;
    }

    public final RadiusSettings radiusSettings() {
        return this.radiusSettings;
    }

    public final RadiusStatus radiusStatus() {
        return RadiusStatus.fromValue(this.radiusStatus);
    }

    public final String radiusStatusAsString() {
        return this.radiusStatus;
    }

    public final String stageReason() {
        return this.stageReason;
    }

    public final Boolean ssoEnabled() {
        return this.ssoEnabled;
    }

    public final Integer desiredNumberOfDomainControllers() {
        return this.desiredNumberOfDomainControllers;
    }

    public final OwnerDirectoryDescription ownerDirectoryDescription() {
        return this.ownerDirectoryDescription;
    }

    public final RegionsInfo regionsInfo() {
        return this.regionsInfo;
    }

    public final OSVersion osVersion() {
        return OSVersion.fromValue(this.osVersion);
    }

    public final String osVersionAsString() {
        return this.osVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsIpAddrs() ? this.dnsIpAddrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareNotes());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageLastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.radiusSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.radiusStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssoEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredNumberOfDomainControllers());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerDirectoryDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionsInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.osVersionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryDescription)) {
            return false;
        }
        DirectoryDescription other = (DirectoryDescription)obj;
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.shortName(), other.shortName()) && Objects.equals(this.sizeAsString(), other.sizeAsString()) && Objects.equals(this.editionAsString(), other.editionAsString()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.accessUrl(), other.accessUrl()) && Objects.equals(this.description(), other.description()) && this.hasDnsIpAddrs() == other.hasDnsIpAddrs() && Objects.equals(this.dnsIpAddrs(), other.dnsIpAddrs()) && Objects.equals(this.stageAsString(), other.stageAsString()) && Objects.equals(this.shareStatusAsString(), other.shareStatusAsString()) && Objects.equals(this.shareMethodAsString(), other.shareMethodAsString()) && Objects.equals(this.shareNotes(), other.shareNotes()) && Objects.equals(this.launchTime(), other.launchTime()) && Objects.equals(this.stageLastUpdatedDateTime(), other.stageLastUpdatedDateTime()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.vpcSettings(), other.vpcSettings()) && Objects.equals(this.connectSettings(), other.connectSettings()) && Objects.equals(this.radiusSettings(), other.radiusSettings()) && Objects.equals(this.radiusStatusAsString(), other.radiusStatusAsString()) && Objects.equals(this.stageReason(), other.stageReason()) && Objects.equals(this.ssoEnabled(), other.ssoEnabled()) && Objects.equals(this.desiredNumberOfDomainControllers(), other.desiredNumberOfDomainControllers()) && Objects.equals(this.ownerDirectoryDescription(), other.ownerDirectoryDescription()) && Objects.equals(this.regionsInfo(), other.regionsInfo()) && Objects.equals(this.osVersionAsString(), other.osVersionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DirectoryDescription").add("DirectoryId", (Object)this.directoryId()).add("Name", (Object)this.name()).add("ShortName", (Object)this.shortName()).add("Size", (Object)this.sizeAsString()).add("Edition", (Object)this.editionAsString()).add("Alias", (Object)this.alias()).add("AccessUrl", (Object)this.accessUrl()).add("Description", (Object)this.description()).add("DnsIpAddrs", this.hasDnsIpAddrs() ? this.dnsIpAddrs() : null).add("Stage", (Object)this.stageAsString()).add("ShareStatus", (Object)this.shareStatusAsString()).add("ShareMethod", (Object)this.shareMethodAsString()).add("ShareNotes", (Object)(this.shareNotes() == null ? null : "*** Sensitive Data Redacted ***")).add("LaunchTime", (Object)this.launchTime()).add("StageLastUpdatedDateTime", (Object)this.stageLastUpdatedDateTime()).add("Type", (Object)this.typeAsString()).add("VpcSettings", (Object)this.vpcSettings()).add("ConnectSettings", (Object)this.connectSettings()).add("RadiusSettings", (Object)this.radiusSettings()).add("RadiusStatus", (Object)this.radiusStatusAsString()).add("StageReason", (Object)this.stageReason()).add("SsoEnabled", (Object)this.ssoEnabled()).add("DesiredNumberOfDomainControllers", (Object)this.desiredNumberOfDomainControllers()).add("OwnerDirectoryDescription", (Object)this.ownerDirectoryDescription()).add("RegionsInfo", (Object)this.regionsInfo()).add("OsVersion", (Object)this.osVersionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ShortName": {
                return Optional.ofNullable(clazz.cast(this.shortName()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.sizeAsString()));
            }
            case "Edition": {
                return Optional.ofNullable(clazz.cast(this.editionAsString()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "AccessUrl": {
                return Optional.ofNullable(clazz.cast(this.accessUrl()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DnsIpAddrs": {
                return Optional.ofNullable(clazz.cast(this.dnsIpAddrs()));
            }
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stageAsString()));
            }
            case "ShareStatus": {
                return Optional.ofNullable(clazz.cast(this.shareStatusAsString()));
            }
            case "ShareMethod": {
                return Optional.ofNullable(clazz.cast(this.shareMethodAsString()));
            }
            case "ShareNotes": {
                return Optional.ofNullable(clazz.cast(this.shareNotes()));
            }
            case "LaunchTime": {
                return Optional.ofNullable(clazz.cast(this.launchTime()));
            }
            case "StageLastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.stageLastUpdatedDateTime()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "VpcSettings": {
                return Optional.ofNullable(clazz.cast(this.vpcSettings()));
            }
            case "ConnectSettings": {
                return Optional.ofNullable(clazz.cast(this.connectSettings()));
            }
            case "RadiusSettings": {
                return Optional.ofNullable(clazz.cast(this.radiusSettings()));
            }
            case "RadiusStatus": {
                return Optional.ofNullable(clazz.cast(this.radiusStatusAsString()));
            }
            case "StageReason": {
                return Optional.ofNullable(clazz.cast(this.stageReason()));
            }
            case "SsoEnabled": {
                return Optional.ofNullable(clazz.cast(this.ssoEnabled()));
            }
            case "DesiredNumberOfDomainControllers": {
                return Optional.ofNullable(clazz.cast(this.desiredNumberOfDomainControllers()));
            }
            case "OwnerDirectoryDescription": {
                return Optional.ofNullable(clazz.cast(this.ownerDirectoryDescription()));
            }
            case "RegionsInfo": {
                return Optional.ofNullable(clazz.cast(this.regionsInfo()));
            }
            case "OsVersion": {
                return Optional.ofNullable(clazz.cast(this.osVersionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ShortName", SHORT_NAME_FIELD);
        map.put("Size", SIZE_FIELD);
        map.put("Edition", EDITION_FIELD);
        map.put("Alias", ALIAS_FIELD);
        map.put("AccessUrl", ACCESS_URL_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DnsIpAddrs", DNS_IP_ADDRS_FIELD);
        map.put("Stage", STAGE_FIELD);
        map.put("ShareStatus", SHARE_STATUS_FIELD);
        map.put("ShareMethod", SHARE_METHOD_FIELD);
        map.put("ShareNotes", SHARE_NOTES_FIELD);
        map.put("LaunchTime", LAUNCH_TIME_FIELD);
        map.put("StageLastUpdatedDateTime", STAGE_LAST_UPDATED_DATE_TIME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("VpcSettings", VPC_SETTINGS_FIELD);
        map.put("ConnectSettings", CONNECT_SETTINGS_FIELD);
        map.put("RadiusSettings", RADIUS_SETTINGS_FIELD);
        map.put("RadiusStatus", RADIUS_STATUS_FIELD);
        map.put("StageReason", STAGE_REASON_FIELD);
        map.put("SsoEnabled", SSO_ENABLED_FIELD);
        map.put("DesiredNumberOfDomainControllers", DESIRED_NUMBER_OF_DOMAIN_CONTROLLERS_FIELD);
        map.put("OwnerDirectoryDescription", OWNER_DIRECTORY_DESCRIPTION_FIELD);
        map.put("RegionsInfo", REGIONS_INFO_FIELD);
        map.put("OsVersion", OS_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DirectoryDescription, T> g) {
        return obj -> g.apply((DirectoryDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryId;
        private String name;
        private String shortName;
        private String size;
        private String edition;
        private String alias;
        private String accessUrl;
        private String description;
        private List<String> dnsIpAddrs = DefaultSdkAutoConstructList.getInstance();
        private String stage;
        private String shareStatus;
        private String shareMethod;
        private String shareNotes;
        private Instant launchTime;
        private Instant stageLastUpdatedDateTime;
        private String type;
        private DirectoryVpcSettingsDescription vpcSettings;
        private DirectoryConnectSettingsDescription connectSettings;
        private RadiusSettings radiusSettings;
        private String radiusStatus;
        private String stageReason;
        private Boolean ssoEnabled;
        private Integer desiredNumberOfDomainControllers;
        private OwnerDirectoryDescription ownerDirectoryDescription;
        private RegionsInfo regionsInfo;
        private String osVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectoryDescription model) {
            this.directoryId(model.directoryId);
            this.name(model.name);
            this.shortName(model.shortName);
            this.size(model.size);
            this.edition(model.edition);
            this.alias(model.alias);
            this.accessUrl(model.accessUrl);
            this.description(model.description);
            this.dnsIpAddrs(model.dnsIpAddrs);
            this.stage(model.stage);
            this.shareStatus(model.shareStatus);
            this.shareMethod(model.shareMethod);
            this.shareNotes(model.shareNotes);
            this.launchTime(model.launchTime);
            this.stageLastUpdatedDateTime(model.stageLastUpdatedDateTime);
            this.type(model.type);
            this.vpcSettings(model.vpcSettings);
            this.connectSettings(model.connectSettings);
            this.radiusSettings(model.radiusSettings);
            this.radiusStatus(model.radiusStatus);
            this.stageReason(model.stageReason);
            this.ssoEnabled(model.ssoEnabled);
            this.desiredNumberOfDomainControllers(model.desiredNumberOfDomainControllers);
            this.ownerDirectoryDescription(model.ownerDirectoryDescription);
            this.regionsInfo(model.regionsInfo);
            this.osVersion(model.osVersion);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShortName() {
            return this.shortName;
        }

        public final void setShortName(String shortName) {
            this.shortName = shortName;
        }

        @Override
        public final Builder shortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public final String getSize() {
            return this.size;
        }

        public final void setSize(String size) {
            this.size = size;
        }

        @Override
        public final Builder size(String size) {
            this.size = size;
            return this;
        }

        @Override
        public final Builder size(DirectorySize size) {
            this.size(size == null ? null : size.toString());
            return this;
        }

        public final String getEdition() {
            return this.edition;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(DirectoryEdition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getAccessUrl() {
            return this.accessUrl;
        }

        public final void setAccessUrl(String accessUrl) {
            this.accessUrl = accessUrl;
        }

        @Override
        public final Builder accessUrl(String accessUrl) {
            this.accessUrl = accessUrl;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getDnsIpAddrs() {
            if (this.dnsIpAddrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsIpAddrs;
        }

        public final void setDnsIpAddrs(Collection<String> dnsIpAddrs) {
            this.dnsIpAddrs = DnsIpAddrsCopier.copy(dnsIpAddrs);
        }

        @Override
        public final Builder dnsIpAddrs(Collection<String> dnsIpAddrs) {
            this.dnsIpAddrs = DnsIpAddrsCopier.copy(dnsIpAddrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIpAddrs(String ... dnsIpAddrs) {
            this.dnsIpAddrs(Arrays.asList(dnsIpAddrs));
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(DirectoryStage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final String getShareStatus() {
            return this.shareStatus;
        }

        public final void setShareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
        }

        @Override
        public final Builder shareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
            return this;
        }

        @Override
        public final Builder shareStatus(ShareStatus shareStatus) {
            this.shareStatus(shareStatus == null ? null : shareStatus.toString());
            return this;
        }

        public final String getShareMethod() {
            return this.shareMethod;
        }

        public final void setShareMethod(String shareMethod) {
            this.shareMethod = shareMethod;
        }

        @Override
        public final Builder shareMethod(String shareMethod) {
            this.shareMethod = shareMethod;
            return this;
        }

        @Override
        public final Builder shareMethod(ShareMethod shareMethod) {
            this.shareMethod(shareMethod == null ? null : shareMethod.toString());
            return this;
        }

        public final String getShareNotes() {
            return this.shareNotes;
        }

        public final void setShareNotes(String shareNotes) {
            this.shareNotes = shareNotes;
        }

        @Override
        public final Builder shareNotes(String shareNotes) {
            this.shareNotes = shareNotes;
            return this;
        }

        public final Instant getLaunchTime() {
            return this.launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final Instant getStageLastUpdatedDateTime() {
            return this.stageLastUpdatedDateTime;
        }

        public final void setStageLastUpdatedDateTime(Instant stageLastUpdatedDateTime) {
            this.stageLastUpdatedDateTime = stageLastUpdatedDateTime;
        }

        @Override
        public final Builder stageLastUpdatedDateTime(Instant stageLastUpdatedDateTime) {
            this.stageLastUpdatedDateTime = stageLastUpdatedDateTime;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DirectoryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final DirectoryVpcSettingsDescription.Builder getVpcSettings() {
            return this.vpcSettings != null ? this.vpcSettings.toBuilder() : null;
        }

        public final void setVpcSettings(DirectoryVpcSettingsDescription.BuilderImpl vpcSettings) {
            this.vpcSettings = vpcSettings != null ? vpcSettings.build() : null;
        }

        @Override
        public final Builder vpcSettings(DirectoryVpcSettingsDescription vpcSettings) {
            this.vpcSettings = vpcSettings;
            return this;
        }

        public final DirectoryConnectSettingsDescription.Builder getConnectSettings() {
            return this.connectSettings != null ? this.connectSettings.toBuilder() : null;
        }

        public final void setConnectSettings(DirectoryConnectSettingsDescription.BuilderImpl connectSettings) {
            this.connectSettings = connectSettings != null ? connectSettings.build() : null;
        }

        @Override
        public final Builder connectSettings(DirectoryConnectSettingsDescription connectSettings) {
            this.connectSettings = connectSettings;
            return this;
        }

        public final RadiusSettings.Builder getRadiusSettings() {
            return this.radiusSettings != null ? this.radiusSettings.toBuilder() : null;
        }

        public final void setRadiusSettings(RadiusSettings.BuilderImpl radiusSettings) {
            this.radiusSettings = radiusSettings != null ? radiusSettings.build() : null;
        }

        @Override
        public final Builder radiusSettings(RadiusSettings radiusSettings) {
            this.radiusSettings = radiusSettings;
            return this;
        }

        public final String getRadiusStatus() {
            return this.radiusStatus;
        }

        public final void setRadiusStatus(String radiusStatus) {
            this.radiusStatus = radiusStatus;
        }

        @Override
        public final Builder radiusStatus(String radiusStatus) {
            this.radiusStatus = radiusStatus;
            return this;
        }

        @Override
        public final Builder radiusStatus(RadiusStatus radiusStatus) {
            this.radiusStatus(radiusStatus == null ? null : radiusStatus.toString());
            return this;
        }

        public final String getStageReason() {
            return this.stageReason;
        }

        public final void setStageReason(String stageReason) {
            this.stageReason = stageReason;
        }

        @Override
        public final Builder stageReason(String stageReason) {
            this.stageReason = stageReason;
            return this;
        }

        public final Boolean getSsoEnabled() {
            return this.ssoEnabled;
        }

        public final void setSsoEnabled(Boolean ssoEnabled) {
            this.ssoEnabled = ssoEnabled;
        }

        @Override
        public final Builder ssoEnabled(Boolean ssoEnabled) {
            this.ssoEnabled = ssoEnabled;
            return this;
        }

        public final Integer getDesiredNumberOfDomainControllers() {
            return this.desiredNumberOfDomainControllers;
        }

        public final void setDesiredNumberOfDomainControllers(Integer desiredNumberOfDomainControllers) {
            this.desiredNumberOfDomainControllers = desiredNumberOfDomainControllers;
        }

        @Override
        public final Builder desiredNumberOfDomainControllers(Integer desiredNumberOfDomainControllers) {
            this.desiredNumberOfDomainControllers = desiredNumberOfDomainControllers;
            return this;
        }

        public final OwnerDirectoryDescription.Builder getOwnerDirectoryDescription() {
            return this.ownerDirectoryDescription != null ? this.ownerDirectoryDescription.toBuilder() : null;
        }

        public final void setOwnerDirectoryDescription(OwnerDirectoryDescription.BuilderImpl ownerDirectoryDescription) {
            this.ownerDirectoryDescription = ownerDirectoryDescription != null ? ownerDirectoryDescription.build() : null;
        }

        @Override
        public final Builder ownerDirectoryDescription(OwnerDirectoryDescription ownerDirectoryDescription) {
            this.ownerDirectoryDescription = ownerDirectoryDescription;
            return this;
        }

        public final RegionsInfo.Builder getRegionsInfo() {
            return this.regionsInfo != null ? this.regionsInfo.toBuilder() : null;
        }

        public final void setRegionsInfo(RegionsInfo.BuilderImpl regionsInfo) {
            this.regionsInfo = regionsInfo != null ? regionsInfo.build() : null;
        }

        @Override
        public final Builder regionsInfo(RegionsInfo regionsInfo) {
            this.regionsInfo = regionsInfo;
            return this;
        }

        public final String getOsVersion() {
            return this.osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        @Override
        public final Builder osVersion(OSVersion osVersion) {
            this.osVersion(osVersion == null ? null : osVersion.toString());
            return this;
        }

        public DirectoryDescription build() {
            return new DirectoryDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectoryDescription> {
        public Builder directoryId(String var1);

        public Builder name(String var1);

        public Builder shortName(String var1);

        public Builder size(String var1);

        public Builder size(DirectorySize var1);

        public Builder edition(String var1);

        public Builder edition(DirectoryEdition var1);

        public Builder alias(String var1);

        public Builder accessUrl(String var1);

        public Builder description(String var1);

        public Builder dnsIpAddrs(Collection<String> var1);

        public Builder dnsIpAddrs(String ... var1);

        public Builder stage(String var1);

        public Builder stage(DirectoryStage var1);

        public Builder shareStatus(String var1);

        public Builder shareStatus(ShareStatus var1);

        public Builder shareMethod(String var1);

        public Builder shareMethod(ShareMethod var1);

        public Builder shareNotes(String var1);

        public Builder launchTime(Instant var1);

        public Builder stageLastUpdatedDateTime(Instant var1);

        public Builder type(String var1);

        public Builder type(DirectoryType var1);

        public Builder vpcSettings(DirectoryVpcSettingsDescription var1);

        default public Builder vpcSettings(Consumer<DirectoryVpcSettingsDescription.Builder> vpcSettings) {
            return this.vpcSettings((DirectoryVpcSettingsDescription)((DirectoryVpcSettingsDescription.Builder)DirectoryVpcSettingsDescription.builder().applyMutation(vpcSettings)).build());
        }

        public Builder connectSettings(DirectoryConnectSettingsDescription var1);

        default public Builder connectSettings(Consumer<DirectoryConnectSettingsDescription.Builder> connectSettings) {
            return this.connectSettings((DirectoryConnectSettingsDescription)((DirectoryConnectSettingsDescription.Builder)DirectoryConnectSettingsDescription.builder().applyMutation(connectSettings)).build());
        }

        public Builder radiusSettings(RadiusSettings var1);

        default public Builder radiusSettings(Consumer<RadiusSettings.Builder> radiusSettings) {
            return this.radiusSettings((RadiusSettings)((RadiusSettings.Builder)RadiusSettings.builder().applyMutation(radiusSettings)).build());
        }

        public Builder radiusStatus(String var1);

        public Builder radiusStatus(RadiusStatus var1);

        public Builder stageReason(String var1);

        public Builder ssoEnabled(Boolean var1);

        public Builder desiredNumberOfDomainControllers(Integer var1);

        public Builder ownerDirectoryDescription(OwnerDirectoryDescription var1);

        default public Builder ownerDirectoryDescription(Consumer<OwnerDirectoryDescription.Builder> ownerDirectoryDescription) {
            return this.ownerDirectoryDescription((OwnerDirectoryDescription)((OwnerDirectoryDescription.Builder)OwnerDirectoryDescription.builder().applyMutation(ownerDirectoryDescription)).build());
        }

        public Builder regionsInfo(RegionsInfo var1);

        default public Builder regionsInfo(Consumer<RegionsInfo.Builder> regionsInfo) {
            return this.regionsInfo((RegionsInfo)((RegionsInfo.Builder)RegionsInfo.builder().applyMutation(regionsInfo)).build());
        }

        public Builder osVersion(String var1);

        public Builder osVersion(OSVersion var1);
    }
}

