/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DataAccessStatus;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDirectoryDataAccessResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeDirectoryDataAccessResponse> {
    private static final SdkField<String> DATA_ACCESS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessStatus").getter(DescribeDirectoryDataAccessResponse.getter(DescribeDirectoryDataAccessResponse::dataAccessStatusAsString)).setter(DescribeDirectoryDataAccessResponse.setter(Builder::dataAccessStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_ACCESS_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDirectoryDataAccessResponse.memberNameToFieldInitializer();
    private final String dataAccessStatus;

    private DescribeDirectoryDataAccessResponse(BuilderImpl builder) {
        super(builder);
        this.dataAccessStatus = builder.dataAccessStatus;
    }

    public final DataAccessStatus dataAccessStatus() {
        return DataAccessStatus.fromValue(this.dataAccessStatus);
    }

    public final String dataAccessStatusAsString() {
        return this.dataAccessStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectoryDataAccessResponse)) {
            return false;
        }
        DescribeDirectoryDataAccessResponse other = (DescribeDirectoryDataAccessResponse)((Object)obj);
        return Objects.equals(this.dataAccessStatusAsString(), other.dataAccessStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDirectoryDataAccessResponse").add("DataAccessStatus", (Object)this.dataAccessStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataAccessStatus": {
                return Optional.ofNullable(clazz.cast(this.dataAccessStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DataAccessStatus", DATA_ACCESS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectoryDataAccessResponse, T> g) {
        return obj -> g.apply((DescribeDirectoryDataAccessResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private String dataAccessStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectoryDataAccessResponse model) {
            super(model);
            this.dataAccessStatus(model.dataAccessStatus);
        }

        public final String getDataAccessStatus() {
            return this.dataAccessStatus;
        }

        public final void setDataAccessStatus(String dataAccessStatus) {
            this.dataAccessStatus = dataAccessStatus;
        }

        @Override
        public final Builder dataAccessStatus(String dataAccessStatus) {
            this.dataAccessStatus = dataAccessStatus;
            return this;
        }

        @Override
        public final Builder dataAccessStatus(DataAccessStatus dataAccessStatus) {
            this.dataAccessStatus(dataAccessStatus == null ? null : dataAccessStatus.toString());
            return this;
        }

        @Override
        public DescribeDirectoryDataAccessResponse build() {
            return new DescribeDirectoryDataAccessResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDirectoryDataAccessResponse> {
        public Builder dataAccessStatus(String var1);

        public Builder dataAccessStatus(DataAccessStatus var1);
    }
}

