/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.internal.UserAgentUtils;
import software.amazon.awssdk.services.directory.model.ClientAuthenticationSettingInfo;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsResponse;

public class DescribeClientAuthenticationSettingsIterable
implements SdkIterable<DescribeClientAuthenticationSettingsResponse> {
    private final DirectoryClient client;
    private final DescribeClientAuthenticationSettingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClientAuthenticationSettingsIterable(DirectoryClient client, DescribeClientAuthenticationSettingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeClientAuthenticationSettingsResponseFetcher();
    }

    public Iterator<DescribeClientAuthenticationSettingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClientAuthenticationSettingInfo> clientAuthenticationSettingsInfo() {
        Function<DescribeClientAuthenticationSettingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clientAuthenticationSettingsInfo() != null) {
                return response.clientAuthenticationSettingsInfo().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeClientAuthenticationSettingsResponseFetcher
    implements SyncPageFetcher<DescribeClientAuthenticationSettingsResponse> {
        private DescribeClientAuthenticationSettingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClientAuthenticationSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeClientAuthenticationSettingsResponse nextPage(DescribeClientAuthenticationSettingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClientAuthenticationSettingsIterable.this.client.describeClientAuthenticationSettings(DescribeClientAuthenticationSettingsIterable.this.firstRequest);
            }
            return DescribeClientAuthenticationSettingsIterable.this.client.describeClientAuthenticationSettings((DescribeClientAuthenticationSettingsRequest)((Object)DescribeClientAuthenticationSettingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

