/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directoryservicedata.model.DirectoryServiceDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupMembersRequest
extends DirectoryServiceDataRequest
implements ToCopyableBuilder<Builder, ListGroupMembersRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(ListGroupMembersRequest.getter(ListGroupMembersRequest::directoryId)).setter(ListGroupMembersRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DirectoryId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListGroupMembersRequest.getter(ListGroupMembersRequest::maxResults)).setter(ListGroupMembersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> MEMBER_REALM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberRealm").getter(ListGroupMembersRequest.getter(ListGroupMembersRequest::memberRealm)).setter(ListGroupMembersRequest.setter(Builder::memberRealm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberRealm").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGroupMembersRequest.getter(ListGroupMembersRequest::nextToken)).setter(ListGroupMembersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REALM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Realm").getter(ListGroupMembersRequest.getter(ListGroupMembersRequest::realm)).setter(ListGroupMembersRequest.setter(Builder::realm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()}).build();
    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMAccountName").getter(ListGroupMembersRequest.getter(ListGroupMembersRequest::samAccountName)).setter(ListGroupMembersRequest.setter(Builder::samAccountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, MAX_RESULTS_FIELD, MEMBER_REALM_FIELD, NEXT_TOKEN_FIELD, REALM_FIELD, SAM_ACCOUNT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGroupMembersRequest.memberNameToFieldInitializer();
    private final String directoryId;
    private final Integer maxResults;
    private final String memberRealm;
    private final String nextToken;
    private final String realm;
    private final String samAccountName;

    private ListGroupMembersRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.maxResults = builder.maxResults;
        this.memberRealm = builder.memberRealm;
        this.nextToken = builder.nextToken;
        this.realm = builder.realm;
        this.samAccountName = builder.samAccountName;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String memberRealm() {
        return this.memberRealm;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String realm() {
        return this.realm;
    }

    public final String samAccountName() {
        return this.samAccountName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberRealm());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.realm());
        hashCode = 31 * hashCode + Objects.hashCode(this.samAccountName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupMembersRequest)) {
            return false;
        }
        ListGroupMembersRequest other = (ListGroupMembersRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.memberRealm(), other.memberRealm()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.realm(), other.realm()) && Objects.equals(this.samAccountName(), other.samAccountName());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupMembersRequest").add("DirectoryId", (Object)this.directoryId()).add("MaxResults", (Object)this.maxResults()).add("MemberRealm", (Object)this.memberRealm()).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Realm", (Object)this.realm()).add("SAMAccountName", (Object)this.samAccountName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "MemberRealm": {
                return Optional.ofNullable(clazz.cast(this.memberRealm()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Realm": {
                return Optional.ofNullable(clazz.cast(this.realm()));
            }
            case "SAMAccountName": {
                return Optional.ofNullable(clazz.cast(this.samAccountName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("MemberRealm", MEMBER_REALM_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Realm", REALM_FIELD);
        map.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGroupMembersRequest, T> g) {
        return obj -> g.apply((ListGroupMembersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryServiceDataRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private Integer maxResults;
        private String memberRealm;
        private String nextToken;
        private String realm;
        private String samAccountName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupMembersRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.maxResults(model.maxResults);
            this.memberRealm(model.memberRealm);
            this.nextToken(model.nextToken);
            this.realm(model.realm);
            this.samAccountName(model.samAccountName);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getMemberRealm() {
            return this.memberRealm;
        }

        public final void setMemberRealm(String memberRealm) {
            this.memberRealm = memberRealm;
        }

        @Override
        public final Builder memberRealm(String memberRealm) {
            this.memberRealm = memberRealm;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRealm() {
            return this.realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final String getSamAccountName() {
            return this.samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupMembersRequest build() {
            return new ListGroupMembersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectoryServiceDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupMembersRequest> {
        public Builder directoryId(String var1);

        public Builder maxResults(Integer var1);

        public Builder memberRealm(String var1);

        public Builder nextToken(String var1);

        public Builder realm(String var1);

        public Builder samAccountName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

