/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PolicyLanguageValues {
    SIMPLIFIED("SIMPLIFIED"),
    STANDARD("STANDARD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PolicyLanguageValues> VALUE_MAP;
    private final String value;

    private PolicyLanguageValues(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PolicyLanguageValues fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PolicyLanguageValues> knownValues() {
        EnumSet<PolicyLanguageValues> knownValues = EnumSet.allOf(PolicyLanguageValues.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PolicyLanguageValues.class, PolicyLanguageValues::toString);
    }
}

